let comboShowType = "combo"
// 天秤座数据
let tczuoData = {
  minsLeftPriceArr: [],
  minsRightPriceArr: [],
  minsDiffPriceArr: [],
  daysLeftPriceArr: [],
  daysRightPriceArr: [],
  daysDiffPriceArr: [],
  minsLeftTimes: [],
  minsRightTimes: [],
  daysLeftDates: [],
  daysRightDates: []
}
let leftLegSysCode   //左腿合约
let rightLegSysCode  //右腿合约

let tcz_minChart //分钟周期
let tcz_dayChart // 日周期

let minsShowType = 'diff'
let daysShowType = 'diff'

let showTczMinIndex = 0
let showTczDayIndex = 0

let comboHaveHisL = false
let comboHaveHisR = false

let comBoChartHeight
let comBoChartWidth

let comboNowSyscode

function ChartComResize() {

  comBoChartHeight = tcz_minChart.getHeight();
  comBoChartWidth = tcz_minChart.getWidth();
  tcz_minChart.setOption(tczMinOption())
  tcz_dayChart.setOption(tczDayOption())
}


function Trigger_comListPrice(syscode, bprice) {
  let diffPrice
  for (var i = 0; i < T_tczuoList.length; i++) {
    let item = T_tczuoList[i]
    if(syscode == item.leftLegSysCode) {
      T_tczuoList[i].leftLegPrice = Number(bprice).toFixed(2)
      comboNowSyscode = item.sysCode
      if(T_tczuoList[i].leftLegPrice != 0 && T_tczuoList[i].rightLegPrice != 0) {
        diffPrice = (Number(T_tczuoList[i].rightLegPrice) - Number(T_tczuoList[i].leftLegPrice)).toFixed(2)
        item['diffPrice'] = diffPrice
        let index = T_tczuoList.findIndex(function (value, index, arr) {
          return value.sysCode == item.sysCode
        })
        if (index == -1) {
          return
        }
        T_tczuoList.splice(index, 1, item)
      } else {
        diffPrice = '—'
      }
      $('#'+comboNowSyscode).html(diffPrice)
      $('#left'+comboNowSyscode).html(Number(bprice).toFixed(2))
      if(diffPrice > 0) {
        $('#'+comboNowSyscode).css('color','#FF5C5C')
      } else if(diffPrice < 0) {
        $('#'+comboNowSyscode).css('color','#39E365')
      }
      
    } else if(syscode == item.rightLegSysCode){
      T_tczuoList[i].rightLegPrice = Number(bprice).toFixed(2)
      comboNowSyscode = item.sysCode
      if(T_tczuoList[i].leftLegPrice != 0 && T_tczuoList[i].rightLegPrice != 0) {
        diffPrice = (Number(T_tczuoList[i].rightLegPrice) - Number(T_tczuoList[i].leftLegPrice)).toFixed(2)
      } else {
        diffPrice = '—'
      }
      $('#'+comboNowSyscode).html(diffPrice)
      $('#right'+comboNowSyscode).html(Number(bprice).toFixed(2))
      if(diffPrice > 0) {
        $('#'+comboNowSyscode).css('color','#FF5C5C')
      } else if(diffPrice < 0) {
        $('#'+comboNowSyscode).css('color','#39E365')
      }
    }
  }
}

function Page_sendMsg(num){
  $('.infinite-list-change').children('.infinite-list-type').eq(num).addClass('active').siblings().removeClass('active')
  $('.content_main').children('.combo_container').eq(num).addClass('active').siblings().removeClass('active')
  if(num === 0) {
    comboShowType = 'combo'
    stock_startNum = 0
    stock_visibleCount = Math.ceil(stockviewH / itemSize) + 4 //展示的数量
    stock_endNum = stock_startNum + stock_visibleCount
    comboListHeight = T_tczuoList.length * itemSize
    let comboList = T_tczuoList.slice(stock_startNum, stock_endNum)
    let leftSysCodeList = comboList.map(item => item.leftLegSysCode)
    let rightSysCodeList = comboList.map(item => item.rightLegSysCode)
    let AllSysCodeList = [...leftSysCodeList,...rightSysCodeList]
    let SysCodeListStr =  AllSysCodeList.join(',')
    Mack_ComboList(comboList)
    window_external.Page_Subscribe(SysCodeListStr)
  } else {
    if(comboShowType == 'periodDiff') {
      return
    }
    comboShowType = 'periodDiff'
    let SysCodeListStr = [...T_qxStockList,...T_qxFuturesStr].join(',')
    Make_ContractList(T_qxFuturesList)
    window_external.Page_Subscribe(SysCodeListStr)
  }
}

//天秤座列表
function Mack_ComboList(comboList) {
  $('#infiniteListPhantom').css("height", comboListHeight + 'px')
  var html = ''
  for (var i = 0; i < comboList.length; i++) {
    let item = comboList[i]
    let diffColor =  item.diffPrice == '—' ? 'pingColor' : (Number(item.diffPrice) > 0 ? 'upColor' : 'downColor')
    html += '<div class="combo-list" onclick="reComboClick(this)" ondblclick="reComboSyscode(\'' + item.sysCode + '\')">'
    html += '<div class="combo-list-item" title="'+item.sysCode+'">' + item.sysCode + '</div>'
    html += '<div class="combo-list-item" title="'+item.instrumentName+'" >' + item.instrumentName + '</div>'
    html += '<div class="combo-list-item">' + item.instrumentAbbr + '</div>'
    html += '<div class="combo-list-item">' + item.endDate + '</div>'
    html += '<div class="combo-list-item ' + diffColor + '"  id="'+item.sysCode+'">' + item.diffPrice + '</div>'
    html += '<div class="combo-list-item">' + item.leftLegSysCode + '</div>'
    html += '<div class="combo-list-item" id="left'+item.sysCode+'">' + item.leftLegPrice + '</div>'
    html += '<div class="combo-list-item">' + item.leftLegExchangeId + '</div>'
    html += '<div class="combo-list-item">' + item.rightLegSysCode + '</div>'
    html += '<div class="combo-list-item" id="right'+item.sysCode+'">' + item.rightLegPrice + '</div>'
    html += '<div class="combo-list-item">' + item.rightLegExchangeId + '</div>'
    html += '</div>'
  }
  $('#infiniteList').html(html)
}


function reComboClick(obj) {
  $(obj).addClass('active').siblings().removeClass('active')
}

function ReLeftlegSyscode(syscode) {
  let index = T_tczuoList.findIndex(function (value, index, arr) {
    return value['sysCode'] == syscode;
  })
  return T_tczuoList[index]['leftLegSysCode']
}

function ReRightlegSyscode(syscode) {
  let index = T_tczuoList.findIndex(function (value, index, arr) {
    return value['sysCode'] == syscode;
  })
  return T_tczuoList[index]['rightLegSysCode']
}

function ReTczName(syscode) {
  let index = T_tczuoList.findIndex(function (value, index, arr) {
    return value['sysCode'] == syscode;
  })
  return T_tczuoList[index]['instrumentName']
}
function CheckComTimes_M(para_time) {
  for (var i = 0; i < tczuoData.times.length; i++) {
    if (tczuoData.times[i] == para_time) {
      return i;
    }
  }
  return -1;
}

//获取数组差
function Get_tczdiff(arr, brr) {
  let diffArr = []
  let arrLen = arr.length
  let brrLen = brr.length
  
  if (arrLen > brrLen) {
    let difNum = arrLen - brrLen
    for(i=difNum;i<arr.length;i++){
      let diff = arr[i] - brr[i-difNum]
      diffArr.push(diff.toFixed(2))
    }
  } else if (arrLen < brrLen) {
    let difNum = brrLen - arrLen
    for(i=difNum;i<brr.length;i++){
      let diff = arr[i-difNum] - brr[i]
      diffArr.push(diff.toFixed(2))
    }
  } else {
    for(i=0;i<arr.length;i++){
      let diff = arr[i] - brr[i]
      diffArr.push(diff.toFixed(2))
    }
  }
  return diffArr
}


//近远期合约重置
function reComboSyscode(syscode) {
  comboHaveHisL = false
  comboHaveHisR = false
  $('#appMain').html(jyqHtml)
  let instrumentName = ReTczName(syscode)
  $('#tcz_titleName').html(instrumentName+' ('+syscode+')')
  leftLegSysCode = ReLeftlegSyscode(syscode)
  rightLegSysCode = ReRightlegSyscode(syscode)
  let productId = ReProductId(leftLegSysCode)
  let timeframe = ReTimeFrame(productId)
  tczuoData = {
    minsLeftPriceArr: [],
    minsRightPriceArr: [],
    minsDiffPriceArr: [],
    daysLeftPriceArr: [],
    daysRightPriceArr: [],
    daysDiffPriceArr: [],
    minsLeftTimes: [],
    minsRightTimes: [],
    daysLeftDates: [],
    daysRightDates: [],
    times: []
  }
  tczuoData.times = time_arr(timeframe)
  minsShowType = 'diff'
  daysShowType = 'diff'
  tcz_minChart = echarts.init(document.getElementById('minDiffmain'));
  tcz_dayChart = echarts.init(document.getElementById('dayDiffmain'));
  window_external.Page_QueryKHistory(leftLegSysCode, 19, -200)
  window_external.Page_QueryKHistory(rightLegSysCode, 19, -200)
  window_external.Page_QueryKHistory(leftLegSysCode, 12, -200)
  window_external.Page_QueryKHistory(rightLegSysCode, 12, -200)
  window_external.Page_Subscribe(leftLegSysCode + ',' + rightLegSysCode)
  tcz_minChart.setOption(tczMinOption())
  tcz_dayChart.setOption(tczDayOption())
  ChartComResize()
  tcz_minChart.on('globalout', function () {
    changeTczMinTitle(0)
  })
  tcz_dayChart.on('globalout', function () {
    changeTczDayTitle(0)
  })
  window.location.hash = '/tczPage'
}


//天秤座历史行情
function Trigger_ComboK(sysCode, dates, times, prices, size, kType) {
  let Adate = dates.split(',')
  let Atime = times.split(',')
  let Aprice = prices.split(',')

  if (leftLegSysCode == sysCode) {
    //19 分钟数据 //12 日数据
    if (kType == 19) {
      for (i = 0; i < size; i++) {
        tczuoData.minsLeftPriceArr[i] = Aprice[i]
        tczuoData.minsLeftTimes[i] = Atime[i].substring(0, 5)
      }

    } else if (kType == 12) {
      for (i = 0; i < size; i++) {
        tczuoData.daysLeftPriceArr[i] = Aprice[i]
        tczuoData.daysLeftDates[i] = Adate[i]
      }
      comboHaveHisL = true

    }
  } else if (rightLegSysCode == sysCode) {
    if (kType == 19) {
      for (i = 0; i < size; i++) {
        tczuoData.minsRightPriceArr[i] = Aprice[i]
        tczuoData.minsRightTimes[i] = Atime[i].substring(0, 5)
      }

    } else if (kType == 12) {
      for (i = 0; i < size; i++) {
        tczuoData.daysRightPriceArr[i] = Aprice[i]
        tczuoData.daysRightDates[i] = Adate[i]
      }
      comboHaveHisR = true
    }
  }
  tcz_minChart.setOption(tczMinOption())
  tcz_dayChart.setOption(tczDayOption())
  
}


// 天秤座实时行情
function Trigger_ComboNow(sysCode, bdate, btime, bprice) {
  if (sysCode == leftLegSysCode) {
    var j = CheckComTimes_M(btime.substring(0, 5)); //返回下标
    let b_time = btime.substring(0, 5)
    let dateLen = tczuoData.daysLeftDates.length
    let lastDay = tczuoData.daysLeftDates[dateLen - 1]
    let timesLen = tczuoData.minsLeftTimes.length

    let lastTime = tczuoData.minsLeftTimes[timesLen - 1]
    let lastIndex = CheckComTimes_M(lastTime.substring(0, 5))
    if (bdate == lastDay) {
      tczuoData.daysLeftPriceArr[dateLen - 1] = parseFloat(bprice).toFixed(2)

      if (b_time == lastTime) {
        tczuoData.minsLeftPriceArr[timesLen - 1] = parseFloat(bprice).toFixed(2)
        tczuoData.minsLeftTimes[timesLen - 1] = btime.substring(0, 5)
      } else {
          tczuoData.minsLeftPriceArr.push(parseFloat(bprice).toFixed(2))
          tczuoData.minsLeftTimes.push(btime.substring(0, 5))
      }
    } else {
      tczuoData.daysLeftPriceArr.push(bprice)
      tczuoData.daysLeftDates.push(bdate)
      tczuoData.minsLeftPriceArr.push(parseFloat(bprice).toFixed(2))
      tczuoData.minsLeftTimes.push(btime.substring(0, 5))
    }
  } else if (sysCode == rightLegSysCode) {
    var j = CheckComTimes_M(btime.substring(0, 5)); //返回下标
    let b_time = btime.substring(0, 5)
    let dateLenR = tczuoData.daysRightDates.length
    let lastDayR = tczuoData.daysRightDates[dateLenR - 1]
    let timesLenR = tczuoData.minsRightTimes.length
    let lastTimeR = tczuoData.minsRightTimes[timesLenR - 1]
    let lastIndex = CheckComTimes_M(lastTimeR.substring(0, 5))
    if (bdate == lastDayR) {
      tczuoData.daysRightPriceArr[dateLenR - 1] = parseFloat(bprice).toFixed(2)

      if (b_time == lastTimeR) {
        tczuoData.minsRightPriceArr[timesLenR - 1] = parseFloat(bprice).toFixed(2)
        tczuoData.minsRightTimes[timesLenR - 1] = btime.substring(0, 5)
      
      } else {
          tczuoData.minsRightPriceArr.push(parseFloat(bprice).toFixed(2))
          tczuoData.minsRightTimes.push(btime.substring(0, 5))
      }
    } else {
      tczuoData.daysRightPriceArr.push(bprice)
      tczuoData.daysRightDates.push(bdate)
      tczuoData.minsRightPriceArr.push(parseFloat(bprice).toFixed(2))
      tczuoData.minsRightTimes.push(btime.substring(0, 5))
    }
  }
  tcz_minChart.setOption(tczMinOption())
  tcz_dayChart.setOption(tczDayOption())
}

function calcTczMa20(data) {
  var result = []
  for (var i = 0; i < data.length; i++) {
    if (i < 20) {
      result.push('-');
      continue;
    }
    var sum = 0;
    for (var j = 0; j < 20; j++) {
      sum += Number(data[i - j])
    }
    result.push((sum / 20).toFixed(2))
  }
  return result
}

function change_tczMins(type, obj) {
  minsShowType = type
  $(obj).addClass('active').siblings().removeClass('active')
  tcz_minChart.setOption(tczMinOption())
}

function change_tczDays(type, obj) {
  daysShowType = type
  $(obj).addClass('active').siblings().removeClass('active')
  tcz_dayChart.setOption(tczDayOption())
}
function calc_showTCZ(list, index) {
  let len = index == 0 ? list.length - 1 : index
  let showk = Number(list[len])
  return showk.toFixed(3)
}


function changeTczMinTitle(dataIndex) {
  showTczMinIndex = dataIndex
  let LeftPriceArr = tczuoData.minsLeftPriceArr.slice(-100)
  let RightPriceArr = tczuoData.minsRightPriceArr.slice(-100)
  let minsDiffPriceArr = Get_tczdiff(tczuoData.minsRightPriceArr, tczuoData.minsLeftPriceArr)
  let DiffArr = minsDiffPriceArr.slice(-100)
  let minsMA20 = calcTczMa20(minsDiffPriceArr)
  let ma20Arr = minsMA20.slice(-100)
  let showLeft = calc_showTCZ(LeftPriceArr, showTczMinIndex)
  let showRight = calc_showTCZ(RightPriceArr, showTczMinIndex)
  let showDiff = calc_showTCZ(DiffArr, showTczMinIndex)
  let showMa20 = calc_showTCZ(ma20Arr, showTczMinIndex)

  let titleText
  if (minsShowType == 'diff') {
    titleText = ['{a|周期: 分}', '{b|价差: ' + showDiff + '}', '{c|MA20: ' + showMa20 + '}'].join(' ')
  } else if (minsShowType == 'double') {
    titleText = ['{a|周期: 分}', '{b|' + leftLegSysCode + ': ' + showLeft + '}', '{c|' + rightLegSysCode + ': ' + showRight + '}'].join(' ')
  }
  tcz_minChart.setOption({
    title:  {
      text: titleText,
      left: '20px',
      top: '1%',
      textStyle: {
        //fontSize: 12,
        //color: '#0e99e2'
        fontSize: 12,
        fontWeight: 0,
        rich: {
          a: {
            color: '#ffffff',
          },
          b: {
            color: '#00bcd4',
          },
          c: {
            color: '#673ab7',
          }
        }
      }
    },
  });
}

function changeTczDayTitle(dataIndex) {
  showTczDayIndex = dataIndex
  let LeftPriceArr = tczuoData.daysLeftPriceArr.slice(-80)
  let RightPriceArr = tczuoData.daysRightPriceArr.slice(-80)
  let daysDiffPriceArr = Get_tczdiff(tczuoData.daysRightPriceArr, tczuoData.daysLeftPriceArr)
  let DiffArr = daysDiffPriceArr.slice(-80)
  let daysMA20 = calcTczMa20(daysDiffPriceArr)
  let ma20Arr = daysMA20.slice(-80)
  let showLeft = calc_showTCZ(LeftPriceArr, showTczDayIndex)
  let showRight = calc_showTCZ(RightPriceArr, showTczDayIndex)
  let showDiff = calc_showTCZ(DiffArr, showTczDayIndex)
  let showMa20 = calc_showTCZ(ma20Arr, showTczDayIndex)

  let titleText
  if (daysShowType == 'diff') {
    titleText = ['{a|周期: 日}', '{b|价差: ' + showDiff + '}', '{c|MA20: ' + showMa20 + '}'].join(' ')
  } else if (daysShowType == 'double') {
    titleText = ['{a|周期: 日}', '{b|' + leftLegSysCode + ': ' + showLeft + '}', '{c|' + rightLegSysCode + ': ' + showRight + '}'].join(' ')
  }
  tcz_dayChart.setOption({
    title:  {
      text: titleText,
      left: '20px',
      top: '1%',
      textStyle: {
        //fontSize: 12,
        //color: '#0e99e2'
        fontSize: 12,
        fontWeight: 0,
        rich: {
          a: {
            color: '#ffffff',
          },
          b: {
            color: '#00bcd4',
          },
          c: {
            color: '#673ab7',
          }
        }
      }
    },
  });
}

function tczMinOption() {
  // let titleText
  let LeftPriceArr = tczuoData.minsLeftPriceArr.slice(-100)
  let RightPriceArr = tczuoData.minsRightPriceArr.slice(-100)
  let minsDiffPriceArr = Get_tczdiff(tczuoData.minsRightPriceArr, tczuoData.minsLeftPriceArr)
  let DiffArr = minsDiffPriceArr.slice(-100)
  let minsMA20 = calcTczMa20(minsDiffPriceArr)
  let ma20Arr = minsMA20.slice(-100)
  let showLeft = calc_showTCZ(LeftPriceArr, showTczMinIndex)
  let showRight = calc_showTCZ(RightPriceArr, showTczMinIndex)
  let showDiff = calc_showTCZ(DiffArr, showTczMinIndex)
  let showMa20 = calc_showTCZ(ma20Arr, showTczMinIndex)
  let titleText
  if (minsShowType == 'diff') {
    titleText = ['{a|周期: 分}', '{b|价差: ' + showDiff + '}', '{c|MA20: ' + showMa20 + '}'].join(' ')
  } else if (minsShowType == 'double') {
    titleText = ['{a|周期: 分}', '{b|' + leftLegSysCode + ': ' + showLeft + '}', '{c|' + rightLegSysCode + ': ' + showRight + '}'].join(' ')
  }
  return {
    title:  {
      text: titleText,
      left: '20px',
      top: '1%',
      textStyle: {
        //fontSize: 12,
        //color: '#0e99e2'
        fontSize: 12,
        fontWeight: 0,
        rich: {
          a: {
            color: '#ffffff',
          },
          b: {
            color: '#00bcd4',
          },
          c: {
            color: '#673ab7',
          }
        }
      }
    },
    grid: {
      left: '60px',
      right: '20px',
      height: (comBoChartHeight - 60) ,
      width: (comBoChartWidth - 80),
      top: '30px'
    },
    legend: { //图例控件,点击图例控制哪些系列不显示
      type: 'scroll',
      itemWidth: 20,
      itemHeight: 2,
      right: '60px',
      top: '3px',
      animation: false,
      textStyle: {
          fontSize: 12,
          color: '#0e99e2'
      },
    },
    color:['#00bcd4','#673ab7'],
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'cross'
      },
      formatter: function (param) {
        changeTczMinTitle(param[0].dataIndex)
      }
    },
    xAxis: { //主图 
      type: 'category',
      data: tczuoData.minsLeftTimes.slice(-100),
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
    },
    yAxis: {
      type: 'value',
      // splitNumber: 5,
      splitLine: {
        show: true,
        lineStyle: {
          color: '#636363',
          width: 1,
          type: 'solid',
          opacity: '0.3'
        }
      },
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    animation: false,//禁止动画效果
    backgroundColor: '#111',
    series: [
      {
        name: minsShowType == 'diff' ? '价差' : '左腿合约',
        type: 'line',
        data: minsShowType == 'diff' ? DiffArr : LeftPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: {
          normal: {
            opacity: 1,
            color: '#00bcd4',
            width: 1
          }
        },
      },
      {
        name: minsShowType == 'diff' ? 'MA20' : '右腿合约',
        type: 'line',
        data: minsShowType == 'diff' ? ma20Arr : RightPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: { //标线的样式
          normal: {
            opacity: 1,
            color: '#673ab7',
            width: 1
          }
        },
      }
    ]
  };
}

function tczDayOption() {
  let LeftPriceArr = tczuoData.daysLeftPriceArr.slice(-80)
  let RightPriceArr = tczuoData.daysRightPriceArr.slice(-80)
  let daysDiffPriceArr = Get_tczdiff(tczuoData.daysRightPriceArr, tczuoData.daysLeftPriceArr)
  let DiffArr = daysDiffPriceArr.slice(-80)
  let daysMA20 = calcTczMa20(daysDiffPriceArr)
  let ma20Arr = daysMA20.slice(-80)
  let showLeft = calc_showTCZ(LeftPriceArr, showTczDayIndex)
  let showRight = calc_showTCZ(RightPriceArr, showTczDayIndex)
  let showDiff = calc_showTCZ(DiffArr, showTczDayIndex)
  let showMa20 = calc_showTCZ(ma20Arr, showTczDayIndex)
  let titleText
  if (daysShowType == 'diff') {
    titleText = ['{a|周期: 日}', '{b|价差: ' + showDiff + '}', '{c|MA20: ' + showMa20 + '}'].join(' ')
  } else if (daysShowType == 'double') {
    titleText = ['{a|周期: 日}', '{b|' + leftLegSysCode + ': ' + showLeft + '}', '{c|' + rightLegSysCode + ': ' + showRight + '}'].join(' ')
  }

  return {
    title:  {
      text: titleText,
      left: '20px',
      top: '1%',
      textStyle: {
        //fontSize: 12,
        //color: '#0e99e2'
        fontSize: 12,
        fontWeight: 0,
        rich: {
          a: {
            color: '#ffffff',
          },
          b: {
            color: '#00bcd4',
          },
          c: {
            color: '#673ab7',
          }
        }
      }
    },
    grid: {
      left: '60px',
      right: '20px',
      height: (comBoChartHeight - 60) ,
      width: (comBoChartWidth - 80),
      top: '30px'
    },
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'cross'
      },
      formatter: function (param) {
        changeTczDayTitle(param[0].dataIndex)
      }
    },
    legend: { //图例控件,点击图例控制哪些系列不显示
      type: 'scroll',
      itemWidth: 20,
      itemHeight: 2,
      right: '60px',
      top: '3px',
      animation: false,
      textStyle: {
          fontSize: 12,
          color: '#0e99e2'
      },
    },
    color:['#00bcd4','#673ab7'],
    xAxis: { //主图 
      type: 'category',
      data: tczuoData.daysLeftDates.slice(-80),
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    yAxis: {
      type: 'value',
      // splitNumber: 5,
      splitLine: {
        show: true,
        lineStyle: {
          color: '#636363',
          width: 1,
          type: 'solid',
          opacity: '0.3'
        }
      },
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    animation: false,//禁止动画效果
    backgroundColor: "#111",
    series: [
      {
        name: daysShowType == 'diff' ? '价差' : '左腿合约',
        type: 'line',
        data: daysShowType == 'diff' ? DiffArr : LeftPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: {
          normal: {
            opacity: 1,
            color: '#00bcd4',
            width: 1
          }
        },
      },
      {
        name: daysShowType == 'diff' ? 'MA20' : '右腿合约',
        type: 'line',
        data: daysShowType == 'diff' ? ma20Arr : RightPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: { //标线的样式
          normal: {
            opacity: 1,
            color: '#673ab7',
            width: 1
          }
        },
      }
    ]
  }
}



//期现差
let qxStockIC = 0
let qxStockIF = 0
let qxStockIH = 0
let qxStockIM = 0
//期现差chart数据
let qxc_diffChart
let qxc_doubleChart
let qxcData = {
  cashPriceArr: [],
  futuresPriceArr:[],
  timesArr:[],
  dateArr:[]
}
let qxcFutureSize = 0
let qxcHaveCashHis = false
let qxcHaveFatureHis =false
let qxcCashCode
let qxcFuturesCode
let qxcChartHeight
let qxcChartWidth
let qxcKtype
function ChartQxcResize() {

  qxcChartHeight = qxc_diffChart.getHeight();
  qxcChartWidth = qxc_diffChart.getWidth();
  qxc_diffChart.setOption(qxcDiffOption())
  qxc_doubleChart.setOption(qxcDoubleOption())
}

function reQxcCashCode(syscode) {
  let code = syscode.substring(0,2)
  let cashCode
  if(code == 'IF') {
    cashCode = '000300.SH'
  } else if(code == 'IC') {
    cashCode = '000905.SH'
  }  else if(code == 'IH') {
    cashCode = '000016.SH'
  } else if(code == 'IM') {
    cashCode = '000852.SH'
  }
  return cashCode

}
//现货指数
function Trigger_qxcStock(sysCode,newPrice,yestClose) {
  let price = newPrice == 0 ? yestClose.toFixed(2) : newPrice.toFixed(2)
  let upDownPer = (Number(newPrice) - Number(yestClose)) / Number(yestClose)
  let updown = newPrice == 0 ? 0 : (upDownPer*100).toFixed(2)
  if (sysCode === '000905.SH') {
    $('#qxStockIC').html(price)
    $('#qxcUpdownIC').html(updown)
    if(updown > 0) {
      $('#qxcUpdownIC').css('color','#FF5C5C')
    } else if(updown < 0) {
      $('#qxcUpdownIC').css('color','#39E365')
    }
    qxStockIC = price
  } else if(sysCode === '000016.SH') {
    $('#qxStockIH').html(price)
    $('#qxcUpdownIH').html(updown)
    if(updown > 0) {
      $('#qxcUpdownIH').css('color','#FF5C5C')
    } else if(updown < 0) {
      $('#qxcUpdownIH').css('color','#39E365')
    }
    qxStockIH = price
  } else if(sysCode === '000300.SH') {
    $('#qxStockIF').html(price)
    $('#qxcUpdownIF').html(updown)
    if(updown > 0) {
      $('#qxcUpdownIF').css('color','#FF5C5C')
    } else if(updown < 0) {
      $('#qxcUpdownIF').css('color','#39E365')
    }
    qxStockIF = price
  } else if(sysCode === '000852.SH') {
    $('#qxStockIM').html(price)
    $('#qxcUpdownIM').html(updown)
    if(updown > 0) {
      $('#qxcUpdownIM').css('color','#FF5C5C')
    } else if(updown < 0) {
      $('#qxcUpdownIM').css('color','#39E365')
    }
    qxStockIM = price
  }
}
// 合约列表
function Make_ContractList(contractList) {
  var html = ''
  for (var i = 0; i < contractList.length; i++) {
    let item = contractList[i]
    let stockId = item.sysCode.replace(/\(|\)|\+|\./g,'')
    let updownColor = item.updown == '_' ?  'pingColor' : (item.updown > 0 ? 'upColor' : 'downColor' )
    let basisColor = item.basis == '_' ?  'pingColor' : (item.basis > 0 ? 'upColor' : 'downColor' )
    let yieldColor = item.yield == '_' ?  'pingColor' : (item.yield > 0 ? 'upColor' : 'downColor' )
    html += '<div class="combo-list" onclick="reComboClick(this)" ondblclick="openQxcHtml(\'' + item.sysCode + '\')">'
    html += '<div class="contract-list-item">' + item.sysCode + '</div>'
    html += '<div class="contract-list-item" id="price'+stockId+'">' + item.newPrice + '</div>'
    html += '<div class="contract-list-item '+updownColor+'" id="upDown'+stockId+'">' + item.updown + '</div>'
    html += '<div class="contract-list-item">' + item.dueDays + '</div>'
    html += '<div class="contract-list-item '+basisColor+'" id="basis'+stockId+'">' + item.basis + '</div>'
    html += '<div class="contract-list-item '+yieldColor+'" id="yield'+stockId+'">' + item.yield + '</div>'
    html += '<div class="contract-list-item">' + item.dueDate + '</div>'
    html += '</div>'
  }
  $('#qxcListContainer').html(html)
}

//期现差排序
let ComboIsUp = true
let ComboSeleteNum = 0

function changeComboListSort(name,num){
  if (ComboSeleteNum != num) {
    ComboIsUp = true
  } else {
    ComboIsUp = !ComboIsUp
  }

  ComboSeleteNum = num
  if (ComboIsUp) {
      $('.ComtableNav-futureBtn').removeClass('isUp')
      $('.ComtableNav-futureBtn').removeClass('isDown')
      $('.ComtableNav-futureBtn').eq(num).addClass('isUp')
      if (name == 'sysCode' || name == 'dueDate') {
        T_qxFuturesList.sort(function (a, b) {
              return a[name].localeCompare(b[name])
          })
      } else {
        T_qxFuturesList.sort(function (a, b) {
              if (a[name] == '—' || b[name] == '—') {
                  return
              } else {
                  return a[name] - b[name]
              }
          })
      }

  } else {
      $('.ComtableNav-futureBtn').removeClass('isUp')
      $('.ComtableNav-futureBtn').removeClass('isDown')
      $('.ComtableNav-futureBtn').eq(num).addClass('isDown')
      if (name == 'sysCode' || name == 'dueDate') {
        T_qxFuturesList.sort(function (a, b) {
              return b[name].localeCompare(a[name])
          })
      } else {
        T_qxFuturesList.sort(function (a, b) {
              if (a[name] == '—' || b[name] == '—') {
                  return
              } else {
                  return b[name] - a[name]
              }
          })
      }

  }
  Make_ContractList(T_qxFuturesList)
}

// 合约实时行情

function Trigger_contract(sysCode, newPrice, yestClose){
  let sysCodeId = sysCode.substring(0,2)
  let new_price = IsZero(newPrice) || IsNumberMax(newPrice) ? '—' : parseFloat(newPrice).toFixed(2)
  let stockPrice
  if (sysCodeId === 'IC') {
    stockPrice = qxStockIC
  } else if(sysCodeId === 'IH') {
    stockPrice = qxStockIH
  } else if(sysCodeId === 'IF') {
    stockPrice = qxStockIF
  } else if(sysCodeId === 'IM') {
    stockPrice = qxStockIM
  }
  let upDownPer = (Number(newPrice) - Number(yestClose)) / Number(yestClose)
  let updown = newPrice == 0 ? 0 : (upDownPer*100).toFixed(2)
  let basis = (Number(stockPrice) - Number(newPrice)).toFixed(2)
  let index = T_qxFuturesList.findIndex(function(value,index,arr){
    return value.sysCode == sysCode
  })

  if(index == -1){
    return
  }
  let dueDays = T_qxFuturesList[index]['dueDays']
  let yield = dueDays == 0 || stockPrice ==0 ? "—" : ((basis / dueDays / stockPrice) * 36500).toFixed(2)
  let obj = T_qxFuturesList[index]
  obj['newPrice'] = new_price
  obj['updown'] = updown
  obj['basis'] = basis
  obj['yield'] = yield
  T_qxFuturesList.splice(index, 1, obj)
  $('#price'+sysCode).html(new_price)
  $('#upDown'+sysCode).html(updown)
  $('#basis'+sysCode).html(basis)
  $('#yield'+sysCode).html(yield)
  if(updown > 0) {
    $('#upDown'+sysCode).css('color','#FF5C5C')
  } else if(updown < 0) {
    $('#upDown'+sysCode).css('color','#39E365')
  }
  if(basis > 0) {
    $('#basis'+sysCode).css('color','#FF5C5C')
  } else if(basis < 0) {
    $('#basis'+sysCode).css('color','#39E365')
  }
  if(yield > 0) {
    $('#yield'+sysCode).css('color','#FF5C5C')
  } else if(yield < 0) {
    $('#yield'+sysCode).css('color','#39E365')
  }
}



//打开合约期现差页面
function openQxcHtml(syscode) {
  $('#appMain').html(qxcHtml)
  qxcFuturesCode = syscode 
  qxcCashCode = reQxcCashCode(syscode)
  $('#qxc_titleName').html(syscode+'---'+qxcCashCode)
  resetQxcSyscode(0,19)
  window.location.hash = '/qxcPage'
}
//切换合约期现差type
function resetQxcSyscode(num,type) {
  qxcKtype = type
  qxcFutureSize = 0
  $('.tcz_side_chartNum').children('.tcz_side_chartName').eq(num).addClass('active').siblings().removeClass('active')
  qxcHaveCashHis = false
  qxcHaveFatureHis =false
  qxcData = {
    cashPriceArr: [],
    futuresPriceArr:[],
    timesArr:[],
    dateArr:[]
  }
  
  qxc_diffChart = echarts.init(document.getElementById('qxcDiffmain'));
  qxc_doubleChart = echarts.init(document.getElementById('qxcDoublemain'));
  window_external.Page_QueryKHistory(qxcFuturesCode, type, -200)
  window_external.Page_QueryKHistory(qxcCashCode, type, -200)
  window_external.Page_Subscribe(qxcFuturesCode + ',' + qxcCashCode)
  qxc_diffChart.setOption(qxcDiffOption())
  qxc_doubleChart.setOption(qxcDoubleOption())
  ChartQxcResize()
}

//期现差历史行情
function Trigger_QxcK(sysCode, dates, times, prices, size, kType) {
  let Adate = dates.split(',')
  let Atime = times.split(',')
  let Aprice = prices.split(',')
  if(sysCode == qxcCashCode) {
    if(kType == 19) {
      for (i = 0; i < size; i++) {
        qxcData.cashPriceArr[i] = Aprice[i]
      }
    } else {
      for (i = 0; i < size; i++) {
        qxcData.cashPriceArr[i] = Aprice[i]
      }
    }
    if(qxcFutureSize != 0) {
      qxcData.cashPriceArr = qxcData.cashPriceArr.slice(-qxcFutureSize)
    }
    qxcHaveCashHis = true

  } else if(sysCode == qxcFuturesCode) {
    qxcFutureSize = size
    if(kType == 19) {
      for (i = 0; i < size; i++) {
        qxcData.futuresPriceArr[i] = Aprice[i]
        qxcData.timesArr[i] = Atime[i].substring(0, 5)
      }
    } else {
      for (i = 0; i < size; i++) {
        qxcData.futuresPriceArr[i] = Aprice[i]
        qxcData.timesArr[i] = Adate[i]
      }
    }
    qxcData.cashPriceArr = qxcData.cashPriceArr.slice(-size)
    qxcHaveFatureHis = true
  }
  qxc_diffChart.setOption(qxcDiffOption())
  qxc_doubleChart.setOption(qxcDoubleOption())
}

//期现差实时行情
//现货实时行情
function Trigger_qxcCashNow(sysCode, bdate, btime, bprice) {

  if(sysCode != qxcCashCode) {
    return
  }
  if(qxcKtype == 19) {
    let b_time = btime.substring(0, 5)
    let timesLen = qxcData.timesArr.length
    let lastTime = qxcData.timesArr[timesLen - 1]
    if(b_time == lastTime) {
      qxcData.cashPriceArr[timesLen - 1] = parseFloat(bprice).toFixed(2)
      qxcData.timesArr[timesLen - 1] = b_time
    } else {
      qxcData.cashPriceArr.push(parseFloat(bprice).toFixed(2))
      qxcData.timesArr.push(b_time)
    }
  } else if(qxcKtype == 12) {
    let timesLen = qxcData.timesArr.length
    let lastDate = qxcData.timesArr[timesLen - 1]
    if(bdate == lastDate) {
      qxcData.cashPriceArr[timesLen - 1] = parseFloat(bprice).toFixed(2)
      qxcData.timesArr[timesLen - 1] = bdate
    } else {
      qxcData.cashPriceArr.push(parseFloat(bprice).toFixed(2))
      qxcData.timesArr.push(bdate)
    }
  } 
  qxc_diffChart.setOption(qxcDiffOption())
  qxc_doubleChart.setOption(qxcDoubleOption())
}

//期貨合约实时行情
function Trigger_qxcFutureNow(sysCode, bdate, btime, bprice) {
  if(sysCode != qxcFuturesCode) {
    return
  }
  if(qxcKtype == 19) {
    let b_time = btime.substring(0, 5)
    let timesLen = qxcData.timesArr.length
    let lastTime = qxcData.timesArr[timesLen - 1]
    if(b_time == lastTime) {
      qxcData.futuresPriceArr[timesLen - 1] = parseFloat(bprice).toFixed(2)
      qxcData.timesArr[timesLen - 1] = b_time
    } else {
      qxcData.futuresPriceArr.push(parseFloat(bprice).toFixed(2))
      qxcData.timesArr.push(b_time)
    }
  } else if(qxcKtype == 12) {
    let timesLen = qxcData.timesArr.length
    let lastDate = qxcData.timesArr[timesLen - 1]
    if(bdate == lastDate) {
      qxcData.futuresPriceArr[timesLen - 1] = parseFloat(bprice).toFixed(2)
      qxcData.timesArr[timesLen - 1] = bdate
    } else {
      qxcData.futuresPriceArr.push(parseFloat(bprice).toFixed(2))
      qxcData.timesArr.push(bdate)
    }
  } 
  qxc_diffChart.setOption(qxcDiffOption())
  qxc_doubleChart.setOption(qxcDoubleOption())
}
function qxcDiffOption() {
  let len = qxcData.futuresPriceArr.length
  let diffPriceArr = Get_tczdiff(qxcData.cashPriceArr,qxcData.futuresPriceArr)
  let DiffArr = diffPriceArr.slice(-len)
  let minsMA20 = calcTczMa20(diffPriceArr)
  let ma20Arr = minsMA20.slice(-len)
  return {
    title:  {
      text: "类型: 基差",
      left: '20px',
      top: '1%',
      textStyle: {
        color: '#ffffff',
        fontSize: 12,
        fontWeight: 0
      }
    },
    grid: {
      left: '60px',
      right: '20px',
      height: (qxcChartHeight - 60) ,
      width: (qxcChartWidth - 80),
      top: '30px'
    },
    legend: { //图例控件,点击图例控制哪些系列不显示
      type: 'scroll',
      itemWidth: 20,
      itemHeight: 2,
      right: '60px',
      top: '3px',
      animation: false,
      textStyle: {
          fontSize: 12,
          color: '#0e99e2'
      },
    },
    color:['#00bcd4','#673ab7'],
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'cross'
      },
      // formatter: function (param) {
      //   changeQxcdiffTitle(param[0].dataIndex)
      // }
    },
    xAxis: { //主图 
      type: 'category',
      data: qxcData.timesArr.slice(-len),
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
    },
    yAxis: {
      type: 'value',
      // splitNumber: 5,
      splitLine: {
        show: true,
        lineStyle: {
          color: '#636363',
          width: 1,
          type: 'solid',
          opacity: '0.3'
        }
      },
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    animation: false,//禁止动画效果
    backgroundColor: '#111',
    series: [
      {
        name: '基差' ,
        type: 'line',
        data: DiffArr,
        smooth: true,
        symbol: "none",
        lineStyle: {
          normal: {
            opacity: 1,
            color: '#00bcd4',
            width: 1
          }
        },
      },
      {
        name: 'MA20',
        type: 'line',
        data:  ma20Arr,
        smooth: true,
        symbol: "none",
        lineStyle: { //标线的样式
          normal: {
            opacity: 1,
            color: '#673ab7',
            width: 1
          }
        },
      }
    ]
  };
}
function qxcDoubleOption() {
  let len = qxcData.futuresPriceArr.length
  let cashPriceArr = qxcData.cashPriceArr.slice(-len)
  return {
    title:  {
      text: '类型: 双轨',
      left: '20px',
      top: '1%',
      textStyle: {
        //fontSize: 12,
        color: '#ffffff',
        fontSize: 12,
        fontWeight: 0,
      }
    },
    grid: {
      left: '60px',
      right: '20px',
      height: (qxcChartHeight - 60) ,
      width: (qxcChartWidth - 80),
      top: '30px'
    },
    legend: { //图例控件,点击图例控制哪些系列不显示
      type: 'scroll',
      itemWidth: 20,
      itemHeight: 2,
      right: '60px',
      top: '3px',
      animation: false,
      textStyle: {
          fontSize: 12,
          color: '#0e99e2'
      },
    },
    color:['#00bcd4','#673ab7'],
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'cross'
      },
      // formatter: function (param) {
      //   changeQxcDouTitle(param[0].dataIndex)
      // }
    },
    xAxis: { //主图 
      type: 'category',
      data: qxcData.timesArr.slice(-len),
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
    },
    yAxis: {
      type: 'value',
      // splitNumber: 5,
      splitLine: {
        show: true,
        lineStyle: {
          color: '#636363',
          width: 1,
          type: 'solid',
          opacity: '0.3'
        }
      },
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    animation: false,//禁止动画效果
    backgroundColor: '#111',
    series: [
      {
        name: qxcCashCode,
        type: 'line',
        data: cashPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: {
          normal: {
            opacity: 1,
            color: '#00bcd4',
            width: 1
          }
        },
      },
      {
        name: qxcFuturesCode,
        type: 'line',
        data:  qxcData.futuresPriceArr,
        smooth: true,
        symbol: "none",
        lineStyle: { //标线的样式
          normal: {
            opacity: 1,
            color: '#673ab7',
            width: 1
          }
        },
      }
    ]
  };
}