function getAllUrlParams(url) {
    // 用JS拿到URL，如果函数接收了URL，那就用函数的参数。如果没传参，就使用当前页面的URL
    var queryString = url ? url.split('?')[1] : window.location.search.slice(1);
    // 用来存储我们所有的参数
    var obj = {};
    // 如果没有传参，返回一个空对象
    if (!queryString) {
        return obj;
    }
    // stuff after # is not part of query string, so get rid of it
    queryString = queryString.split('#')[0];
    // 将参数分成数组
    var arr = queryString.split('&');
    for (var i = 0; i < arr.length; i++) {
        // 分离成key:value的形式
        var a = arr[i].split('=');
        // 将undefined标记为true
        var paramName = a[0];
        var paramValue = typeof (a[1]) === 'undefined' ? true : a[1];
        // 如果调用对象时要求大小写区分，可删除这两行代码
        //paramName = paramName.toLowerCase();
        //if (typeof paramValue === 'string') paramValue = paramValue.toLowerCase();
        // 如果paramName以方括号结束, e.g. colors[] or colors[2]
        if (paramName.match(/\[(\d+)?\]$/)) {
            // 如果paramName不存在，则创建key
            var key = paramName.replace(/\[(\d+)?\]/, '');
            if (!obj[key]) obj[key] = [];
            // 如果是索引数组 e.g. colors[2]
            if (paramName.match(/\[\d+\]$/)) {
                // 获取索引值并在对应的位置添加值
                var index = /\[(\d+)\]/.exec(paramName)[1];
                obj[key][index] = paramValue;
            } else {
                // 如果是其它的类型，也放到数组中
                obj[key].push(paramValue);
            }
        } else {
            // 处理字符串类型
            if (!obj[paramName]) {
                // 如果如果paramName不存在，则创建对象的属性
                obj[paramName] = paramValue;
            } else if (obj[paramName] && typeof obj[paramName] === 'string') {
                // 如果属性存在，并且是个字符串，那么就转换为数组
                obj[paramName] = [obj[paramName]];
                obj[paramName].push(paramValue);
            } else {
                // 如果是其它的类型，还是往数组里丢
                obj[paramName].push(paramValue);
            }
        }
    }
    return obj;
}
function ReTimeFrame(productId) {
    let index = T_instrumentList.findIndex(function(value, index, arr){
        return value['productId'] == productId;
    })
    return T_instrumentList[index]['timeframe']
}

function ReProductId(sysCode) {
    let index = T_modelList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    return T_modelList[index]['productId']
}

function ReInstrumentName(sysCode){
    let index = T_modelList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return sysCode
    }
    return T_modelList[index]['instrumentName']
}

function RePriceDecimal(productId) {
    let index = T_instrumentList.findIndex(function(value, index, arr){
        return value['productId'] == productId;
    })
    return T_instrumentList[index]['priceDecimal']
}

//获取昨收盘
function ReMarketPrePrice(sysCode) {
    let index = T_ysetCloseList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return '0'
    }
    return T_ysetCloseList[index]['yestClose']
}

//获取各时段平均值
function getMean(arr){
    // alert(arr)
    let yarr = arr || []
    let newarr=[]
    for(i=1;i<=yarr.length;i++){
        var b = yarr.slice(0,i).reduce(function(a,b){
            return Number(a) + Number(b)
        })
        var a = b / i
        newarr.push(a.toFixed(2))
    }
    return newarr
}

function NumTransform(num, index) {
    var index = arguments[1] ? arguments[1] : 0;
    // console.log('hou:'+num)
    // alert(num)
    num = parseInt(num);
    if (num < 10000)
        return num;
    else if (num < 100000000)
        return (num / 10000).toFixed(index) + '万';
    else if (num < 1000000000000)
        return (num / 100000000).toFixed(index) + '亿';
    else
        return (num / 1000000000000).toFixed(index) + '万亿';
}


//num-原始数量 如果是股票的话 ÷100
function ProduceVolume(num, index) {
    
    var index = arguments[1] ? arguments[1] : 0;
    num = parseInt(num);
    let str;
    switch (g_productId) {
        case "KSH": //科创板
        case "SHA": //上海A股
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
        case "BJA":  //北京A股
		
            str = NumTransform((num + 99) / 100, index);
            //if(type == 0)
            str += "手";
            break;
        case "SZBond":
        case "SZBondRep":
            str = NumTransform(num / 10, index);
            str += "手";
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = NumTransform(num, index);
    }
    return str;
}

function generate_x_label(timestr) {
    let timestrArray = timestr.split('$');
    let timeArr = new Array();
    let timeArr2 = new Array();
    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
        timeArr.length = 0;
        timeArr.push(timestrArray[i]);
        timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 1, timeArr));
        for (let k = 0; k < timeArr.length; k++) {
            if (k % 30 == 0)
                timeArr2.push(timeArr[k]);
        }
    }
    timeArr2.shift();

    let x_labels = new Array();
    for (j = 0; j < timeArr2.length; j++) {
        x_labels.push({ xAxis: timeArr2[j] });
    }
    return x_labels;
}

//获取增加指定分钟数的数组  如 09:30增加2分钟  结果为 ['09:31','09:32'] 
//9:30-11:30 其中11:30不需要产生
function getNextTime(startTime, endTime, offset, resultArr) {
    var result = addTimeStr(startTime, offset);
    if (result == endTime){
        return resultArr;
    } else {
        resultArr.push(result);
        return getNextTime(result, endTime, offset, resultArr);
    }
}

function move_div(){
    var oDiv = document.getElementById('showDiv')
    var title = document.getElementById('top_title')
    var disX = 0;
    var disY = 0;
    var isDown = false;
    title.onmousedown = function (ev) {
        title.style.cursor = 'move'
        var oEvent = ev || event;
        
        disX = oEvent.clientX - oDiv.offsetLeft;
        disY = oEvent.clientY - oDiv.offsetTop;
        isDown = true
        
        document.onmousemove = function (ev) {
            if(isDown == false){
                return
            }
            var oEvent = ev || event;
            var l = oEvent.clientX - disX;
            var t = oEvent.clientY - disY;
            //此处的判断是为了防止拖拽框被拖出屏幕可视区域
            if (l < 0) {
                l = 0;
            } else if (l > document.documentElement.clientWidth - oDiv.offsetWidth) {
                l = document.documentElement.clientWidth - oDiv.offsetWidth;
            }
            if (t < 0) {
                t = 0;
            } else if (t > document.documentElement.clientHeight - oDiv.offsetHeight) {
                t = document.documentElement.clientHeight - oDiv.offsetHeight;
            }
            oDiv.style.left = l + 'px';
            oDiv.style.top = t + 'px';
        };
        //此处是为了防止在火狐浏览器下拖拽时会出现的两次阴影的效果，此处代码可以禁用
        document.onmouseup = function () {
            isDown = false
            title.style.cursor = 'default'
            document.onmousemove = null;
            document.onmouseup = null;
        }
    }
    
}