function changeShauDays(days,obj) {
    $(obj).addClass('active').siblings().removeClass('active')
    $.ajax({
        url: sURL36+"?count="+days,
        type: 'get',
        timeout: 5000,
        success: function (data) {
            makeShauList(data.data)
            let shauChart = echarts.init(document.getElementById('shauChartMain'));
            shauChart.setOption(shauOption(data.data))
        },
        error: function (jqXHR, textStatus, errorThrown) {
        }
    })
}

function showShauitem() {
    $.ajax({
        url: sURL36+"?count=1",
        type: 'get',
        timeout: 5000,
        success: function (data) {
            const item = data.data[0]
            $('#shau_date').html(item.tradingday)
            $('#shau_price1').html(item.price1)
            $('#shau_price2').html(item.price2)
        },
        error: function (jqXHR, textStatus, errorThrown) {
        }
    })
}
   
function resetShau() {
    $('#appMain').html(shauHtml)
    changeShauDays(30)
    window.location.hash = '/shauPage'
}
function makeShauList(list) {
    let html = ''
    for(let i=0;i<list.length;i++) {
        let item = list[i]
        html+='<div class="shau-table-item">'
        html+='<div class="shau-table-itemli">SHAU</div>'
        html+='<div class="shau-table-itemli">上海金</div>'
        html+='<div class="shau-table-itemli">'+item.tradingday+'</div>'
        html+='<div class="shau-table-itemli">'+item.price1+'</div>'
        html+='<div class="shau-table-itemli">'+item.price2+'</div>'
        html+='</div>'
    }
    $('#shau_table').html(html)
}

function shauOption(data) {
  let times = data.map(item => item.tradingday).reverse()
  let price1 = data.map(item => item.price1).reverse()
  let price2 = data.map(item => item.price2).reverse()
  return {
    color:['#00bcd4','#673ab7'],
    tooltip: {
      trigger: 'axis',
      axisPointer: {
        type: 'cross'
      },
      
      formatter: function (params) {
         let html = '<div>交易日 ' +params[0].name + '</div>';
        html += '<div>早盘价 ' +params[0].value + '</div>';
        html += '<div>午盘价 ' +params[1].value + '</div>';
        return html;
      }
    },
    xAxis: { //主图 
      type: 'category',
      data: times,
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
    },
    yAxis: {
      type: 'value',
      splitLine: {
        show: true,
        lineStyle: {
          color: '#636363',
          width: 1,
          type: 'solid',
          opacity: '0.3'
        }
      },
      axisLabel: {
        textStyle: {
          color: '#969696'
        }
      },
      scale: true
    },
    animation: false,//禁止动画效果
    backgroundColor: '#111',
    series: [
      {
        type: 'line',
        data: price1,
        // smooth: true,
        symbol: "none",
        lineStyle: {
          normal: {
            opacity: 1,
            color: '#00bcd4',
            width: 1
          }
        },
      },
      {
       
        type: 'line',
        data: price2,
        symbol: "none",
        lineStyle: { //标线的样式
          normal: {
            opacity: 1,
            color: '#673ab7',
            width: 1
          }
        },
      }
    ]
  };
}
