let g_marketNodataColor = "#DDDDDD";
let g_marketUpColor = "#FF5C5C";//"#F9293E";
let g_marketDownColor = "#39E365";//"#00FF00";
let g_myChart1
let g_myChart2
let g_kChart1
let g_kChart2
let g_marketPrePrice1 = 1.0;
let g_marketPrePrice2 = 1.0;
let g_marketFirstShow1 = true
let g_marketFirstShow2 = true
let g_myChartHeight
let g_haveIndexHistory = new Array()
let g_xsd_data = new Array()
let g_IndexTradingDay
let XSD_InsturmentIdArray = []
let XSD_insturmentNameArray = []
let XSD_TimeFrameArray = []
let XSD_PriceDecimalArray = []
let XSD_ProductIdArray = []
let XSD_PrepriceArray = []

let g_KRawdata = []

function Trigger_SetPara(instrumentID, insturmentName, timeframe, priceDecimal, productId, TradingDay, preClosePrice) {
    XSD_InsturmentIdArray = instrumentID.split(';')
    XSD_insturmentNameArray = insturmentName.split(';')
    XSD_TimeFrameArray = timeframe.split(';')
    XSD_PriceDecimalArray = priceDecimal.split(';')
    XSD_ProductIdArray = productId.split(';')
    XSD_PrepriceArray = preClosePrice.split(';')
    for (let i = 0; i < XSD_TimeFrameArray.length; i++) {
        let ssdata = generate_Indextimeframe(XSD_TimeFrameArray[i], i)
        g_xsd_data.push(ssdata)
    }
    g_myChart1 = echarts.init(document.getElementById('myChart1'));
    g_myChart2 = echarts.init(document.getElementById('myChart2'));
    g_kChart1 = echarts.init(document.getElementById('kChart1'));
    g_kChart2 = echarts.init(document.getElementById('kChart2'));
    g_myChartHeight = g_myChart1.getHeight();
    g_myChart1.resize();
    g_myChart2.resize();
    ChartResize();
    g_myChart1.setOption(initXSDMOption(g_xsd_data[0]));
    g_myChart2.setOption(initXSDMOption(g_xsd_data[1]));
}


function Trigger_M2(Sdata) {
    const data = JSON.parse(Sdata)
    let TradingDay = data.TradingDay
    let InstrumentID = data.InstrumentID
    let LastPrice = data.LastPrice ?? 0
    let Volume = data.Volume ?? 0
    let UpdateTime = data.UpdateTime
    if (g_haveHistory && Number(LastPrice) > 0) {
      Trigger_M_Now(InstrumentID, UpdateTime, LastPrice,  Volume,TradingDay)
    }
  }




function generate_Indextimeframe(timestr, index) {
    var priceArr = new Array();
    var vol = new Array();
    var nvolume = new Array();
    var times = time_arr(timestr);
    var g_M_XLabels = generate_x_label(timestr);
    var title = XSD_insturmentNameArray[index];
    var productId = XSD_ProductId[index]
    var yestclose = XSD_Preprice[index]
    let priceDecimal = XSD_PriceDecimalArray[index]
    return {
        newPrice: 1,
        priceArr: priceArr,
        vol: vol,
        times: times,
        g_M_XLabels: g_M_XLabels,
        productId: productId,
        title: title,
        yestclose: yestclose,
        priceDecimal,
        priceMax: 2.0,
        priceMin: 1.0,
        bMaxMin: 0,
        volumeMax: 1,
        volumeMin: 0,
        nvolume: nvolume
    }
}


//找不到返回-1,找到返回下标0开始
function CheckTimes_XSDM(para_time, index) {
    for (var i = 0; i < g_xsd_data[index].times.length; i++) {
        if (g_xsd_data[index].times[i] == para_time)
            return i;
    }
    return -1;
}

function CheckId_Xsd(id) {
    for (var i = 0; i < XSD_InsturmentIdArray.length; i++) {
        if (XSD_InsturmentIdArray[i] == id)
            return i;
    }
    return -1;
}

function XsdhaveHistory(id) {
    for (var i = 0; i < g_haveIndexHistory.length; i++) {
        if (g_haveIndexHistory[i] == id)
            return true;
    }
    return false;
}

function SetXsdMaxMin(price, volume, index) {
    if (g_xsd_data[index].bMaxMin == 0) {
        g_xsd_data[index].priceMax = price;
        g_xsd_data[index].priceMin = price;
        g_xsd_data[index].bMaxMin = 1;
    }

    if (g_xsd_data[index].priceMax < price) {
        g_xsd_data[index].priceMax = price;
    }
    if (g_xsd_data[index].priceMin > price) {
        g_xsd_data[index].priceMin = price;
    }

    volume = parseInt(volume);
    if (g_xsd_data[index].volumeMax < volume) {
        g_xsd_data[index].volumeMax = volume;
    }
    if (g_xsd_data[index].volumeMin > volume) {
        g_xsd_data[index].volumeMin = volume;
    }
}


function BalanceXsdMaxMin(index) {


    if (g_xsd_data[index].priceMax < g_xsd_data[index].yestclose)
        g_xsd_data[index].priceMax = g_xsd_data[index].yestclose;
    if (g_xsd_data[index].priceMin > g_xsd_data[index].yestclose)
        g_xsd_data[index].priceMin = g_xsd_data[index].yestclose;

    if ((g_xsd_data[index].priceMax >= g_xsd_data[index].yestclose) && (g_xsd_data[index].priceMax < g_xsd_data[index].yestclose * 1.01))
        g_xsd_data[index].priceMax = g_xsd_data[index].yestclose * 1.01;
    if ((g_xsd_data[index].priceMin <= g_xsd_data[index].yestclose) && (g_xsd_data[index].priceMin > g_xsd_data[index].yestclose * 0.99))
        g_xsd_data[index].priceMin = g_xsd_data[index].yestclose * 0.99;

    let absValue = (Math.abs(g_xsd_data[index].priceMax - g_xsd_data[index].yestclose) > Math.abs(g_xsd_data[index].priceMin - g_xsd_data[index].yestclose)) ?
        Math.abs(g_xsd_data[index].priceMax - g_xsd_data[index].yestclose) : Math.abs(g_xsd_data[index].priceMin - g_xsd_data[index].yestclose);

    g_xsd_data[index].priceMax = g_xsd_data[index].yestclose + absValue;
    g_xsd_data[index].priceMin = g_xsd_data[index].yestclose - absValue;

}

// 集合竞价期间左侧分时图需要初始化 并设置昨收盘(昨结算)
function xsdM_FirstShow(para_prePrice, index) {

    para_prePrice = parseFloat(para_prePrice);

    if (index == 0) {
        if (g_indexmarketFirstShow1 == true) {
            g_indexmarketFirstShow1 = false
            g_xsd_data[index].yestclose = para_prePrice;
            g_xsd_data[0].newPrice = para_prePrice;
            SetXsdMaxMin(para_prePrice, 0, index);
            BalanceXsdMaxMin(index);
            g_indexChart1.setOption(initXSDMOption(g_xsd_data[0]));
        }
    } else if (index == 1) {
        if (g_indexmarketFirstShow2 == true) {
            g_indexmarketFirstShow2 = false
            g_xsd_data[index].yestclose = para_prePrice;
            g_xsd_data[index].newPrice = para_prePrice;
            SetXsdMaxMin(para_prePrice, 0, index);
            BalanceXsdMaxMin(index);
            g_indexChart2.setOption(initXSDMOption(g_xsd_data[1]));
        }
    } 

}
function Trigger_XSDPrePrice(para_prePrice, index) {
    g_IndexmarketPrePrice = para_prePrice;
    xsdM_FirstShow(g_IndexmarketPrePrice, index);

}


// 获取历史数据
function Trigger_MXSD_History(sysCode, times, price, volume, volumeChange, size, prePrice, preSettlementPrice, TradingDay) {

    g_haveIndexHistory.push(sysCode)

    let index = CheckId_Xsd(sysCode)

    if (size == 0) {
        return
    }

    xsdM_FirstShow(prePrice, index);
    let aPrice = price.split(',');
    let volumeArr = volume.split(',');
    let aVolume = volumeChange.split(',');

    for (var i = 0; i < size; i++) {
        g_xsd_data[index].priceArr[i] = parseFloat(aPrice[i]).toFixed(XSD_PriceDecimalArray[index]);
        g_xsd_data[index].vol[i] = aVolume[i];
        g_xsd_data[index].nvolume[i] = volumeArr[i]
        SetXsdMaxMin(parseFloat(aPrice[i]).toFixed(XSD_PriceDecimalArray[index]), parseInt(aVolume[i]), index);
    }
    BalanceXsdMaxMin(index);
    g_xsd_data[index].newPrice = parseFloat(aPrice[Number(size) - 1]).toFixed(2)
    if (index == 0) {
        g_indexChart1.setOption(initXSDMOption(g_xsd_data[0]));
    } else if (index == 1) {
        g_indexChart2.setOption(initXSDMOption(g_xsd_data[1]));
    }

}

// 即时数据
function Trigger_MXSD_Now(b_id, b_time, b_price,  b_volume,TradingDay) {
    if(Number(TradingDay) > Number(g_IndexTradingDay)){
        g_IndexTradingDay = TradingDay
        for(i=0;i<2;i++){
            g_xsd_data[i].priceArr = []
            g_xsd_data[i].vol = []
            g_xsd_data[i].nvolume = []
        } 
        g_indexChart1.setOption(initXSDMOption(g_xsd_data[0]));
        g_indexChart2.setOption(initXSDMOption(g_xsd_data[1]));
    } else if(Number(TradingDay) < Number(g_IndexTradingDay) || TradingDay == undefined){
         return   
    }
    let index = CheckId_Xsd(b_id)
    if(index == -1) {
        return
    }
    let j = CheckTimes_XSDM(b_time.substring(0, 5), index); //返回下标
    if (j == -1) {
        return;
    }
    
    let priceLength = g_xsd_data[index].priceArr.length
    g_xsd_data[index].newPrice = parseFloat(b_price).toFixed(2)
    if (j < priceLength) {
        g_xsd_data[index].priceArr[priceLength - 1] = parseFloat(b_price).toFixed(XSD_PriceDecimalArray[index]);
        g_xsd_data[index].vol[priceLength - 1] = Number(b_volume) - Number(g_xsd_data[index].nvolume[priceLength - 2]);
        g_xsd_data[index].nvolume[priceLength - 1] = b_volume
    } else if (j == g_xsd_data[index].priceArr.length) {
        g_xsd_data[index].priceArr.push(parseFloat(b_price).toFixed(XSD_PriceDecimalArray[index]));
        g_xsd_data[index].nvolume.push(b_volume)
        g_xsd_data[index].vol.push(Number(b_volume) - Number(g_xsd_data[index].nvolume[priceLength - 2]));
    } else {
        for (k = priceLength; k < j; k++) {
            let last_price = g_xsd_data[index].priceArr[priceLength - 1] == undefined ? g_xsd_data[index].yestclose : g_xsd_data[index].priceArr[priceLength - 1]
            g_xsd_data[index].priceArr.push(last_price);
            g_xsd_data[index].vol.push("0");
            g_xsd_data[index].nvolume.push(g_xsd_data[index].nvolume[priceLength - 1])
        }
        g_xsd_data[index].priceArr.push(parseFloat(b_price).toFixed(XSD_PriceDecimalArray[index]));
        g_xsd_data[index].nvolume.push(b_volume)
        g_xsd_data[index].vol.push(Number(b_volume) - Number(g_xsd_data[index].nvolume[priceLength - 2]));

    }
    let volumechange = Number(b_volume) - Number(g_xsd_data[index].nvolume[priceLength - 2])
    SetXsdMaxMin(Number(b_price), volumechange, index)
    BalanceXsdMaxMin(index);
    if (index == 0) {
        g_indexChart1.setOption(initXSDMOption(g_xsd_data[0]));
    } else if (index == 1) {
        g_indexChart2.setOption(initXSDMOption(g_xsd_data[1]));
    } else {
        g_indexChart3.setOption(initXSDMOption(g_xsd_data[2]));
    }

}


function initXSDMOption(g_Mdata) {
    return {
        grid: [
            {
                id: 'gd1',
                left: '60px',
                right: '60px',
                height: (g_indexChartHeight - 60) * 0.73,
                top: '30px',
            },
            {
                id: 'gd2',
                left: '60px',
                right: '60px',
                height: (g_indexChartHeight - 60) * 0.73,//'67.5%', //主K线的高度,
                top: '30px',
            },
            {
                id: 'gd3',
                left: '60px',
                right: '60px',
                top: (g_indexChartHeight - 60) * 0.73 + 30,//'74.5%',
                height: (g_indexChartHeight - 60) * 0.27, //'22%', //交易量图的高度
                bottom: '10px',
            }
        ],
        xAxis: [ //==== x轴
            { //主图 
                //type: 'time',
                gridIndex: 0,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    show: false
                },
                splitLine: {
                    show: false,
                },
                axisTick: {
                    show: false
                },
                //splitNumber: 2,
            },
            {   //主图右侧
                show: false,
                gridIndex: 1,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    show: false
                },
                splitLine: {
                    show: false,
                }
            },
            { //交易量图
                //splitNumber: 2,
                type: 'category',
                gridIndex: 2,
                data: g_Mdata.times,
                axisLabel: { //label文字设置
                    textStyle: {
                        color: "#c7c7c7",
                        fontSize: 12,
                    },
                    //color: function (value, index) {
                    //    return "#c7c7c7";
                    //},
                    interval: 59,
                    fontSize: 12,

                },
            },
        ],
        yAxis: [ //y轴
            {
                gridIndex: 0,
                //scale: true,
                axisLabel: { //label文字设置 
                    inside: false, //label文字朝内对齐 
                    //fontWeight: 'bold',
                    color: function (val) {
                        if (Math.abs(val - g_Mdata.yestclose) < g_doubleMin) {
                            return '#aaaaaa';
                        }
                        return val > g_Mdata.yestclose ? g_upColor : g_downColor;
                    },
                    formatter: function (val, index) {
                        //if (index === 0)    //第一个不显示 免得和成交量label重叠
                        //    return;
                        return Number(val).toFixed(g_Mdata.priceDecimal);
                    },
                    showMinLabel: false,
                },
                z: 4,
                splitLine: { //分割线设置
                    show: true,
                    lineStyle: {
                        color: '#646464',
                        opacity: 0.3,
                    }
                },


                splitNumber: 7,
                max: g_Mdata.priceMax,
                min: g_Mdata.priceMin,
                interval: ((g_Mdata.priceMax - g_Mdata.priceMin) / 6),
                //max: g_MMax,
                //min: g_MMin,
            },
            {
                scale: true,
                gridIndex: 1,
                position: 'right',
                z: 4,
                axisLabel: { //label文字设置
                    color: function (val) {
                        if (Math.abs(val - g_Mdata.yestclose) < g_doubleMin) {
                            return '#aaaaaa';
                        }
                        return val > g_Mdata.yestclose ? g_upColor : g_downColor;
                    },
                    inside: false, //label文字朝内对齐 
                    //fontWeight: 'bold',
                    formatter: function (val) {
                        return ratioCalculate3(val, g_Mdata.yestclose) + '%';
                    },
                    showMinLabel: false,
                },
                splitLine: { //分割线设置
                    show: false,
                    lineStyle: {
                        color: '#181a23'
                    }
                },

                splitNumber: 7,
                max: g_Mdata.priceMax,
                min: g_Mdata.priceMin,
                interval: ((g_Mdata.priceMax - g_Mdata.priceMin) / 6),
            },
            { //交易量图
                gridIndex: 2,
                position: 'left',
                z: 4,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: { //分割线设置
                    show: true,
                    lineStyle: {
                        color: '#646464',
                        opacity: 0.3,
                    }
                },
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false,
                    formatter: function (value, index) {
                        return ProduceVolume4(value, g_Mdata.productId, 0);
                    },
                    //fontSize: 8
                },

                splitNumber: 3,
                max: g_Mdata.volumeMax,
                min: 0,
                interval: ((g_Mdata.volumeMax) / 2),
            },
            { //交易量图右侧
                gridIndex: 2,
                position: 'right',
                z: 4,
                //splitNumber: 3,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: {
                    show: false
                },
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false,
                    formatter: function (value, index) {
                        return ProduceVolume4(value, g_Mdata.productId, 0);
                    },
                    //fontSize: 8
                },

                splitNumber: 3,
                max: g_Mdata.volumeMax,
                min: 0,
                interval: ((g_Mdata.volumeMax) / 2),
            }
        ],
        dataZoom: [
        ],
        animation: false,//禁止动画效果
        backgroundColor: g_bgColor,
        blendMode: 'source-over',
        series: [
            {
                name: '当前价',
                type: 'line',
                data: g_Mdata.priceArr,
                smooth: true,
                areaStyle: {
                    normal: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            offset: 0,
                            color: 'rgba(0, 136, 212, 0.7)'
                        }, {
                            offset: 0.8,
                            color: 'rgba(0, 136, 212, 0.02)'
                        }], false),
                        shadowColor: 'rgba(0, 0, 0, 0.1)',
                        shadowBlur: 10
                    }
                },
                symbol: "circle", //中时有小圆点 
                symbolSize: 2,
                showSymbol: false,
                lineStyle: {
                    normal: {
                        opacity: 1,
                        color: '#39afe6',
                        width: 1
                    }
                },

                markLine:
                {
                    symbol: 'none',
                    label:
                    {
                        //color: "#fff"
                        show: false,
                    },
                    lineStyle:
                    {
                        type: "solid",
                        color: '#646464',
                        opacity: 0.3,
                    },
                    data: g_Mdata.g_M_XLabels,
                },
            },

            {
                type: 'line',
                data: g_Mdata.priceArr,
                smooth: true,
                symbol: "none",
                gridIndex: 1,
                xAxisIndex: 1,
                yAxisIndex: 1,
                lineStyle: { //标线的样式 
                    normal: {
                        width: 0
                    }
                }
            },
            {
                name: '成交量',
                type: 'bar',
                gridIndex: 2,
                xAxisIndex: 2,
                yAxisIndex: 2,
                data: g_Mdata.vol,
                barWidth: '60%',
                itemStyle: {
                    normal: {
                        color: function (params) {
                            var colorList;
                            var compareVar = (params.dataIndex <= 0) ? g_Mdata.yestclose : g_Mdata.priceArr[params.dataIndex - 1];

                            if (g_Mdata.priceArr[params.dataIndex] >= compareVar) {
                                colorList = g_upColor;
                            } else {
                                colorList = g_downColor;
                            }
                            return colorList;
                        },
                    }
                },
                markLine:
                {
                    symbol: 'none',
                    label:
                    {
                        show: false,
                    },
                    lineStyle:
                    {
                        type: "solid",
                        color: '#646464',
                        opacity: 0.3,
                    },
                    data: g_Mdata.g_M_XLabels,
                }
            }
        ]
    };
}



// k线图历史数据
// 数据意义：开盘(open)，收盘(close)，最低(lowest)，最高(highest)
function Trigger_XSDPortfolioK(sysCode, para_date, per_time, per_yestClose, para_open, para_close, para_low, para_high, volume, volumeChange, size, k_type) {
    $('#k_main').addClass('active').siblings().removeClass('active')
    let index = CheckId_Xsd(sysCode)
    g_kChart.resize();
    if (g_kType == k_type) {
        g_haveKhistory = true
        let F_open = per_yestClose.split(',')
        let dates = para_date.split(',');
        let times = per_time.split(',');
        let lastDay = dates[size - 1]
        let opens = para_open.split(',');
        let closes = para_close.split(',');
        let lows = para_low.split(',');
        let highs = para_high.split(',');
        let volumes = volumeChange.split(',');
        let allVols = volume.split(',')
        let UpDown = Hour_changeVol1(closes, F_open)
        let yestClose = Hour_last(closes, F_open)
        let UpDownPer = get_upPer(UpDown, yestClose)
        g_KRawdata[index] = new Array();
        g_KRawdata[index]['size'] = size
        g_KRawdata[index]['lastDay'] = lastDay
        for (var i = 0; i < size; i++) {
            g_KRawdata[index][i] = new Array();
            if (k_type == 19 || k_type == 10) {
                g_KRawdata[index][i][0] = times[i];
            } else {
                g_KRawdata[index][i][0] = dates[i];
            }
            //   g_KRawdata[index][i][0] = dates[i];
            g_KRawdata[index][i][1] = parseFloat(opens[i]);
            g_KRawdata[index][i][2] = parseFloat(closes[i]);
            g_KRawdata[index][i][3] = parseFloat(lows[i]);
            g_KRawdata[index][i][4] = parseFloat(highs[i]);
            if (k_type == 13 || k_type == 14) {
                g_KRawdata[index][i][5] = parseInt(allVols[i]);
            } else {
                g_KRawdata[index][i][5] = parseInt(volumes[i]);
            }
            g_KRawdata[index][i][6] = parseFloat(UpDown[i]);
            g_KRawdata[index][i][7] = parseFloat(UpDownPer[i]);
            g_KRawdata[index][i][8] = parseFloat(allVols[i]);
            g_KRawdata[index][i][9] = (times[i]).substring(9, 17);
            g_KRawdata[index][i][10] = true
        }
        if (size < 70) {
            for (i = size; i < 70; i++) {
                g_KRawdata[index].push(['', '', '', '', '', '', '', '', '', '', true])
            }
        }
        if(index == 0) {
            g_kChart1.setOption(initXSDKOption(g_KRawdata[0]));
        } else if(index == 1) {
            g_kChart2.setOption(initXSDKOption(g_KRawdata[1]));
        }
        // g_kChart.setOption(initXSDKOption(g_KRawdata[index]));
    // }
    } else {    
        g_haveKhistory = true
        let pretimes = per_time.split(',');
        let firstAllowTime
        let filterNum
        if(g_kType == '15') { //15分钟k线
            firstAllowTime = ['00','15','30','45']
            filterNum = 3
        } else if(g_kType == '30') {
            firstAllowTime = ['00','30']
            filterNum = 6
        }
        
        let firstIndex = pretimes.findIndex((value => firstAllowTime.includes(value.substring(12,14))) )
        let F_openArr = per_yestClose.split(',').splice(firstIndex)
        let F_open = splitDateTime(F_openArr,filterNum).map(item => item[0])
        let datesArr = para_date.split(',').splice(firstIndex)
        let dates = splitDateTime(datesArr,filterNum).map(item => item[0])
        let timesArr = per_time.split(',').splice(firstIndex);
        let times = splitDateTime(timesArr,filterNum).map(item => item[0])
        let opensArr = para_open.split(',').splice(firstIndex);
        let opens = splitDateTime(opensArr,filterNum).map(item => item[0])
        let closesArr = para_close.split(',').splice(firstIndex);
        let closes = splitDateTime(closesArr,filterNum).map(item => item[item.length-1])
        let lowsArr = para_low.split(',').splice(firstIndex);
        let lows = splitDateTime(lowsArr,filterNum).map(item => Math.min.apply(null,item))
        let highsArr = para_high.split(',').splice(firstIndex);
        let highs = splitDateTime(highsArr,filterNum).map(item => Math.max.apply(null,item))
        let volumesArr = volumeChange.split(',').splice(firstIndex);
        let volumes = splitDateTime(volumesArr,filterNum).map(item => item.reduce(function(prev,cur) {
            return Number(prev) + Number(cur)
        },0))
        let allVolsArr = volume.split(',').splice(firstIndex);
        let allVols = splitDateTime(allVolsArr,filterNum).map(item => item[item.length-1])
        let UpDown = Hour_changeVol1(closes, F_open)
        let yestClose = Hour_last(closes, F_open)
        let UpDownPer = get_upPer(UpDown, yestClose)
        let size = times.length
        let lastDay = dates[size - 1]
        g_KRawdata[index] = new Array();
        g_KRawdata[index]['size'] = size
        g_KRawdata[index]['lastDay'] = lastDay
        for (var i = 0; i < size; i++) {
            g_KRawdata[index][i] = new Array();
            g_KRawdata[index][i][0] = times[i];
            g_KRawdata[index][i][1] = parseFloat(opens[i]);
            g_KRawdata[index][i][2] = parseFloat(closes[i]);
            g_KRawdata[index][i][3] = parseFloat(lows[i]);
            g_KRawdata[index][i][4] = parseFloat(highs[i]);
            g_KRawdata[index][i][5] = parseInt(volumes[i]);
            g_KRawdata[index][i][6] = parseFloat(UpDown[i]);
            g_KRawdata[index][i][7] = parseFloat(UpDownPer[i]);
            g_KRawdata[index][i][8] = parseFloat(allVols[i]);
            g_KRawdata[index][i][9] = (times[i]).substring(9, 17);
            g_KRawdata[index][i][10] = true
        }
        if (size < 70) {
            for (i = size; i < 70; i++) {
                g_KRawdata[index].push(['', '', '', '', '', '', '', '', '', '', true])
            }
        }
        if(index == 0) {
            g_kChart1.setOption(initXSDKOption(g_KRawdata[0]));
        } else if(index == 1) {
            g_kChart2.setOption(initXSDKOption(g_KRawdata[1]));
        }
    } 
    // $('#k_main').addClass('active').siblings().removeClass('active')
    // g_kChart.resize();
    
}


let hisVol
//k线图实时数据
function Trigger_XSDk_Now(sysCode, bdate, btime, lastPrice, closePrice, Volume) {
    // let eTime = g_timeframe.split('$')[3]
    // let endtime = eTime.substring(0, 2)+eTime.substring(3, 5)+'00'
    // let btimeNum = btime.substring(0, 2)+btime.substring(3, 5)+btime.substring(6, 8)
    // if(Number(btimeNum) >= Number(endtime)) {
    //     return
    // }
    let index = CheckId_Xsd(sysCode)
    let j = CheckTimes_M(btime.substring(0, 5))
    if (j == -1 || lastPrice == 0) {
        return
    }
    if (g_kType == '19') {
        let size = g_KRawdata[index].length
        let lastTime = g_KRawdata[index][size - 1][0]
        let lastIndex = CheckTimes_M(lastTime.substring(0, 5))
        let nextIndex = CheckTimes_M(btime.substring(0, 5))
        if (lastIndex == nextIndex) {
            let yesclosePrice = g_KRawdata[index][size - 2][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume
            if (nextIndex == 0) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            
            let dataList = [lastTime, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let yesclosePrice = g_KRawdata[index][size - 1][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume
            if (nextIndex == 0) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            let dataList = [btime, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '10') {
        let size = g_KRawdata[index].size
        let lastTime = (g_KRawdata[index][size - 1][0])
        let lastIndex = CheckTimes_Msplit(lastTime.substring(9, 14), 5)
        let nextIndex = CheckTimes_Msplit(btime.substring(0, 5), 5)
        if (lastIndex == nextIndex) {
            let yesclosePrice = g_KRawdata[index][size - 2][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }

            let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let yesclosePrice = g_KRawdata[index][size - 1][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            let dateTime = bdate+' '+btime
            let dataList = [dateTime, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '15') { // 15分钟
        let size = g_KRawdata[index].size
        let lastTime = (g_KRawdata[index][size - 1][0])
        let lastIndex = CheckTimes_Msplit(lastTime.substring(9, 14), 15)
        let nextIndex = CheckTimes_Msplit(btime.substring(0, 5), 15)
        if (lastIndex == nextIndex) {
            let yesclosePrice = g_KRawdata[index][size - 2][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }

            let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let yesclosePrice = g_KRawdata[index][size - 1][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            let dateTime = bdate+' '+btime
            let dataList = [dateTime, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '30') { // 30分钟
        let size = g_KRawdata[index].size
        let lastTime = (g_KRawdata[index][size - 1][0])
        let lastIndex = CheckTimes_Msplit(lastTime.substring(9, 14), 30)
        let nextIndex = CheckTimes_Msplit(btime.substring(0, 5), 30)
        if (lastIndex == nextIndex) {
            let yesclosePrice = g_KRawdata[index][size - 2][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }

            let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let yesclosePrice = g_KRawdata[index][size - 1][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            let dateTime = bdate+' '+btime
            let dataList = [dateTime, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '11') {
        let size = g_KRawdata[index].size
        let lastTime = (g_KRawdata[index][size - 1][9])
        let lastIndex = CheckTimes_Msplit(lastTime.substring(0, 5), 60)
        let nextIndex = CheckTimes_Msplit(btime.substring(0, 5), 60)
        if (lastIndex == nextIndex) {
            let yesclosePrice = g_KRawdata[index][size - 2][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }

            let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            let yesclosePrice = g_KRawdata[index][size - 1][2]
            let unDown = Number(lastPrice) - Number(yesclosePrice)
            let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume
            if (nextIndex == 1) {
                volume = Number(Volume)
            } else {
                volume = Number(Volume) - Number(g_KRawdata[index][size - 2][8])
            }
            let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '12') {
        let size = g_KRawdata[index].size
        let lastTime = g_KRawdata[index]['lastDay']
        let unDown = Number(lastPrice) - Number(closePrice)
        let unDownPer = (parseFloat(unDown) / parseFloat(closePrice))*100
        if (lastTime == bdate) {
            let openPrice = g_KRawdata[index][size - 1][1]
            let closes = parseFloat(lastPrice)
            let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
            let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
            let volume = Number(Volume)
            let dataList = [bdate, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index][size - 1] = dataList
        } else {
            g_KRawdata[index]['lastDay'] = bdate
            g_KRawdata[index].size = Number(g_KRawdata[index].size) + 1
            let openPrice = parseFloat(lastPrice)
            let closes = parseFloat(lastPrice)
            let high_price = parseFloat(lastPrice)
            let low_price = parseFloat(lastPrice)
            let volume = Number(Volume)
            let dataList = [bdate, openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, true]
            g_KRawdata[index].push(dataList)
        }
    } else if (g_kType == '13' || g_kType == '14') {
        let size = g_KRawdata[index].size
        let yesclosePrice = g_KRawdata[index][size - 2][2]
        let unDown = Number(lastPrice) - Number(yesclosePrice)
        let unDownPer = (parseFloat(unDown) / parseFloat(yesclosePrice))*100
        if (g_KRawdata[index][size - 1][10] == true) {
            hisVol = g_KRawdata[index][size - 1][5]
        }
        let openPrice = g_KRawdata[index][size - 1][1]
        let closes = parseFloat(lastPrice)
        let high_price = Number(g_KRawdata[index][size - 1][4]) > Number(lastPrice) ? Number(g_KRawdata[index][size - 1][4]) : Number(lastPrice)
        let low_price = Number(g_KRawdata[index][size - 1][3]) < Number(lastPrice) ? Number(g_KRawdata[index][size - 1][3]) : Number(lastPrice)
        let volume = Number(Volume) + Number(hisVol)
        let dataList = [g_KRawdata[index][size - 1][0], openPrice, closes, low_price, high_price, volume, unDown, unDownPer, Number(Volume), btime, false]
        g_KRawdata[index][size - 1] = dataList
    }
    if(index == 0) {
        g_kChart1.setOption(initXSDKOption(g_KRawdata[0]));
    } else if(index == 1) {
        g_kChart2.setOption(initXSDKOption(g_KRawdata[1]));
    }
}

function splitData(rawData) {
    let size = rawData.size
    var datas = []; var times = []; var vols = []; var closes = [];
    let len = rawData.length
    for (var i = 0; i < len; i++) {
        datas.push(rawData[i].slice(1));
        times.push(rawData[i][0]);
        vols.push(rawData[i][5]);
        //length++;
    }
    for (var i = 0; i < size; i++) {
        closes.push(rawData[i][2])
        //length++;
    }

    return { datas: datas, times: times, vols: vols, size: size, closes: closes };
}


function initXSDKOption(cdata) {
    var showSize = cdata.size - 1
    var data = splitData(cdata);
    kCdzStart = kCdzStart == 0 ? data.datas.length - 70 : kCdzStart
    kCdzEnd = kCdzEnd == 0 ? data.datas.length - 1 : kCdzEnd 
    if(g_kType == '12') {
        g_historyStartDay = g_KRawdata[index][kCdzStart][0]
        g_historyEndDay = g_KRawdata[index][kCdzEnd][0]
    }
    let spData = []
    for (var i = 0; i < data.datas.length; i++) {
        if (data.datas[i][0] != '') {
            spData.push(data.datas[i])
        }
    }
    let lastDay = cdata.lastDay
    
    return {
        title: [{    //标题
            text: g_charttitle,
            left: '50px',
            top: '8px',
            textStyle: {
                //fontSize: 12,
                //color: '#0e99e2'
                color: '#DDDDDD',
                fontSize: 13,
                fontWeight: 0
            },
        }],
        tooltip: { //弹框指示器
            trigger: 'axis',
            axisPointer: {
                type: 'cross'
            },
            position: function (pos, params, el, elRect, size) {
                var obj = { top: '15%' };
                obj[['left', 'right'][+(pos[0] < size.viewSize[0] / 2)]] = 70;
                return obj;
            },
            textStyle: {
                align: 'left'
            },
            hideDelay: 2000,
            formatter: function (param) {
                var i = param[0].dataIndex;
                K_TooltipSide = i
                if (data.datas[i][0] == '') {
                    return
                }
                changeSecTitle(param[0].dataIndex)
                //return param.name + '<br>' + (param.data.coord || ''); 
                param = param[0];
                return [
                    param.name + '<br/>',
                    '开盘价: ' + data.datas[param.dataIndex][0].toFixed(g_priceDecimal) + '<br/>',
                    '收盘价: ' + data.datas[param.dataIndex][1].toFixed(g_priceDecimal) + '<br/>',
                    '最低价: ' + data.datas[param.dataIndex][2].toFixed(g_priceDecimal) + '<br/>',
                    '最高价: ' + data.datas[param.dataIndex][3].toFixed(g_priceDecimal) + '<br/>',
                    '成交量: ' + ProduceVolume(data.vols[param.dataIndex], 2) + '<br/>',
                    '涨跌: ' + data.datas[param.dataIndex][5].toFixed(g_priceDecimal) + '<br/>',
                    '涨跌幅: ' + data.datas[param.dataIndex][6].toFixed(2) + '%<br/>',
                    'MA5: ' + calculateMAbyIndex(5, data, parseInt(param.dataIndex)) + '<br/>',
                    'MA10: ' + calculateMAbyIndex(10, data, parseInt(param.dataIndex)) + '<br/>',
                    'MA20: ' + calculateMAbyIndex(20, data, parseInt(param.dataIndex)) + '<br/>',
                    'MA30: ' + calculateMAbyIndex(30, data, parseInt(param.dataIndex)) + '<br/>',
                    'MA180: ' + calculateMAbyIndex(180, data, parseInt(param.dataIndex)) + '<br/>',
                ].join('');

            }
        },
        legend: { //图例控件,点击图例控制哪些系列不显示
            icon: 'rect',
            type: 'scroll',
            itemWidth: 14,
            itemHeight: 2,
            right: '80px',
            top: '8px',
            animation: false,
            textStyle: {
                //fontSize: 12,
                color: '#0e99e2'
            },
            pageIconColor: '#0e99e2',
        },
        axisPointer: {
            show: true,
            link: { xAxisIndex: 'all' }
        },
        color: [g_ma5Color, g_ma10Color, g_ma20Color, g_ma30Color, g_ma180Color,'#FFFF00', '#FF00FF'],
        grid: [{
            id: 'gd1',
            left: '60px',
            right: '20px',
            height: '65%', //主K线的高度,
            top: '6%'
        }, {
            left: '60px',
            right: '20px',
            top: '73.5%',
            height: '15%' //交易量图的高度
        }],
        
        xAxis: [ //==== x轴
            { //主图
                type: 'category',
                data: data.times,

                boundaryGap: true,
                //   axisLine: {
                //       onZero: false
                //   },
                axisLabel: { //label文字设置
                    show: false
                },
                splitLine: {
                    show: false,
                    lineStyle: {
                        color: '#3a3a3e'
                    }
                },
                splitNumber: 20,
                axisPointer: {
                    label:
                    {
                        formatter: function (params) {
                            // alert(params)
                            if (params.value == '') {
                                return lastDay
                            } else {
                                return params.value
                            }
                        }
                    }
                },
                min: 'dataMin',
                max: 'dataMax'
            }, { //交易量图
                type: 'category',
                boundaryGap: true,
                gridIndex: 1,
                data: data.times,
                axisLabel: { //label文字设置
                    show: false
                },
                axisPointer: {
                    label:
                    {
                        show: false
                    }
                },
                axisLine: {
                    lineStyle: {
                        color: '#222',
                        width: 2
                    }
                }
            },
            
        ],
        yAxis: [ //y轴
            { //==主图
                scale: true,
                z: 4,
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false, //label文字朝内对齐
                    formatter: function (value, index) {
                        return value.toFixed(2);
                    }
                },
                splitLine: { //分割线设置
                    show: false,
                    lineStyle: {
                        color: '#181a23'
                    }
                },
                axisPointer: {
                    label: {
                        precision: 2
                    }
                }
            }, { //交易图
                gridIndex: 1,
                splitNumber: 3,
                z: 4,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: {
                    show: false
                },
                axisLabel: { //label文字设置
                    color: '#c7c7c7',
                    inside: false, //label文字朝内对齐 
                    formatter: function (value, index) {
                        return ProduceVolume(value, 0);
                    }
                    //fontSize: 8
                },
                axisPointer: {
                    show: true,
                    label: {
                        formatter: function (params) {
                            return ProduceVolume(params.value);
                        }
                    }
                }
            },
            { //MACD
                gridIndex: 2,
                splitNumber: 3,
                z: 4,
                axisLine: {
                    onZero: false
                },
                axisTick: {
                    show: false
                },
                splitLine: {
                    show: false
                },
                axisLabel: { //label文字设置
                    color: function (val) {
                        if (val == 0) {
                            return '#aaaaaa';
                        }
                        return val > 0 ? g_upColor : g_downColor;
                    },
                    inside: false, //label文字朝内对齐 
                    // formatter: function (value, index) {
                    //     return ProduceVolume(value, 0);
                    // }
                    //fontSize: 8
                },
            }
        ],
        dataZoom: [{
            type: 'slider',
            show: true,
            zoomOnMouseWheel: true,
            xAxisIndex: [0, 1, 2], //控件联动
            startValue: kCdzStart == 0 ? ((data.datas.length >= 70) ? (data.datas.length - 70) : (0)) : kCdzStart,
            endValue:  kCdzEnd,
            throttle: 100,
            top: '89%',
            height: '6%',
            borderColor: '#696969',
            realtime:false,
            textStyle: {
                color: '#dcdcdc'
            },
            handleSize: '70%', //滑块图标
            handleIcon: 'M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
            dataBackground: {
                lineStyle: {
                    color: '#fff'
                }, //数据边界线样式
                areaStyle: {
                    color: '#696969'

                } //数据域填充样式
            }
        },
        {
            type: 'inside',
            xAxisIndex: [0, 1, 2],//控件联动
        },
        ],
        animation: false, //禁止动画效果
        backgroundColor: g_bgColor,
        blendMode: 'source-over',
        series: [{
            type: 'candlestick',
            data: data.datas,
            barWidth: '55%',
            large: true,
            largeThreshold: 100,
            itemStyle: {
                normal: {
                    color: g_upColor, //fd2e2e  ff4242
                    color0: g_downColor,
                    borderColor: g_upColor,
                    borderColor0: g_downColor,

                    //opacity:0.8
                }
            },
            markPoint:
                {
                    label: {
                        normal: {
                            formatter: function (param) {
                                return param != null ? param.value : '';
                            }
                        }
                    },
                    data: g_M_HisTradeMarks,
                    tooltip: {
                        trigger: 'item',
                        formatter: function (params) {
                            var html = ''
                            for (k = 0; k < params.name.length; k++) {
                                let btype = params.name[k].num === true ? '买' : '卖'                       
                                li = '<li><span>' + btype + '&nbsp;</span><span>成交价格:&nbsp</span><span>' + params.name[k].price + '</span><span>&nbsp;&nbsp;成交数量:&nbsp</span><span>' + params.name[k].volume + '</span></li>'
                                html += li
                            }
                            return html
                        }
                    }
                }
        }, {
            name: 'MA5',
            type: 'line',
            data: calculateMA(5, data),
            smooth: true,
            symbol: "none", //隐藏选中时有小圆点
            lineStyle: {
                normal: {
                    opacity: 0.8,
                    color: g_ma5Color,
                    width: 1
                }
            },
        },
        {
            name: 'MA10',
            type: 'line',
            data: calculateMA(10, data),
            smooth: true,
            symbol: "none", //隐藏选中时有小圆点
            lineStyle: {
                normal: {
                    opacity: 0.8,
                    color: g_ma10Color,
                    width: 1
                }
            },
        },
        {
            name: 'MA20',
            type: 'line',
            data: calculateMA(20, data),
            smooth: true,
            symbol: "none", //隐藏选中时有小圆点
            lineStyle: {
                normal: {
                    opacity: 0.8,
                    color: g_ma20Color,
                    width: 1
                }
            },
        },
        {
            name: 'MA30',
            type: 'line',
            data: calculateMA(30, data),
            smooth: true,
            symbol: "none", //隐藏选中时有小圆点
            lineStyle: {
                normal: {
                    opacity: 0.8,
                    color: g_ma30Color,
                    width: 1
                }
            },
        },{
            name: 'MA180',
            type: 'line',
            data: calculateMA(180, data),
            smooth: true,
            symbol: "none", //隐藏选中时有小圆点
            lineStyle: {
                normal: {
                    opacity: 0.8,
                    color: g_ma180Color,
                    width: 1
                }
            },
        }, {
            name: '成交量', 
            type: 'bar',
            xAxisIndex: 1,
            yAxisIndex: 1,
            data: data.vols,
            barWidth: '60%',
            itemStyle: {
                normal: {
                    color: function (params) {
                        var colorList;
                        if (data.datas[params.dataIndex][1] > data.datas[params.dataIndex][0]) {
                            colorList = g_upColor;
                        } else {
                            colorList = g_downColor;
                        }
                        return colorList;
                    },
                }
            }
        },
        
        ]
    };
}



function Page_XSDchangeType(type, subtype) {
    // g_type1 = type
    g_haveKhistory = false
    $(this).addClass('active').siblings().removeClass('active')
    if (type == 2) {
        $('#myChart1').addClass('active').siblings().removeClass('active')
        g_myChart1.resize();
        ChartResize();
    } else {
        g_kType1 = subtype

        if(subtype == '15') {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[0], 10, -1500)
        } else if(subtype == '30') {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[0], 10, -3000)
        } else {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[0], subtype, -500)
        }
        $('#kChart1').addClass('active').siblings().removeClass('active')
        g_kChart1.resize();
        ChartResize();
    }
}

function Page_XSDchangeType1(type, subtype) {
    // g_type2 = type
    g_haveKhistory = false
    $(this).addClass('active').siblings().removeClass('active')
    if (type == 2) {
        $('#myChart2').addClass('active').siblings().removeClass('active')
        g_myChart2.resize();
        ChartResize();
    } else {
        g_kType2 = subtype

        if(subtype == '15') {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[1], 10, -1500)
        } else if(subtype == '30') {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[1], 10, -3000)
        } else {
            window_external.Page_QueryKHistory(XSD_InsturmentIdArray[1], subtype, -500)
        }
        $('#kChart2').addClass('active').siblings().removeClass('active')
        g_kChart2.resize();
        ChartResize();
    }
}

