function getAllUrlParams(url) {
    // 用JS拿到URL，如果函数接收了URL，那就用函数的参数。如果没传参，就使用当前页面的URL
    var queryString = url ? url.split('?')[1] : window.location.search.slice(1);
    // 用来存储我们所有的参数
    var obj = {};
    // 如果没有传参，返回一个空对象
    if (!queryString) {
        return obj;
    }
    // stuff after # is not part of query string, so get rid of it
    queryString = queryString.split('#')[0];
    // 将参数分成数组
    var arr = queryString.split('&');
    for (var i = 0; i < arr.length; i++) {
        // 分离成key:value的形式
        var a = arr[i].split('=');
        // 将undefined标记为true
        var paramName = a[0];
        var paramValue = typeof (a[1]) === 'undefined' ? true : a[1];
        // 如果调用对象时要求大小写区分，可删除这两行代码
        //paramName = paramName.toLowerCase();
        //if (typeof paramValue === 'string') paramValue = paramValue.toLowerCase();
        // 如果paramName以方括号结束, e.g. colors[] or colors[2]
        if (paramName.match(/\[(\d+)?\]$/)) {
            // 如果paramName不存在，则创建key
            var key = paramName.replace(/\[(\d+)?\]/, '');
            if (!obj[key]) obj[key] = [];
            // 如果是索引数组 e.g. colors[2]
            if (paramName.match(/\[\d+\]$/)) {
                // 获取索引值并在对应的位置添加值
                var index = /\[(\d+)\]/.exec(paramName)[1];
                obj[key][index] = paramValue;
            } else {
                // 如果是其它的类型，也放到数组中
                obj[key].push(paramValue);
            }
        } else {
            // 处理字符串类型
            if (!obj[paramName]) {
                // 如果如果paramName不存在，则创建对象的属性
                obj[paramName] = paramValue;
            } else if (obj[paramName] && typeof obj[paramName] === 'string') {
                // 如果属性存在，并且是个字符串，那么就转换为数组
                obj[paramName] = [obj[paramName]];
                obj[paramName].push(paramValue);
            } else {
                // 如果是其它的类型，还是往数组里丢
                obj[paramName].push(paramValue);
            }
        }
    }
    return obj;
  }

function RefullSyscode(code,exchangeId) {
    let eID
    if(exchangeId == 'SSE') {
        eID = '.SH'
    } else if(exchangeId == 'SZSE') {
        if(code.length == 6) {
            eID = '.SZ'
        } else if(code.length == 5){
            eID ='.HK'
        } else {
            eID = ''
        }
    } else {
        eID = ''
    }
    return code+eID
}
function ReTimeFrame(productId) {
    let index = T_instrumentList.findIndex(function(value, index, arr){
        return value['productId'] == productId;
    })
    return T_instrumentList[index]['timeframe']
}

function ReVolumeMultiple(productId, exchangeId) {
    if(exchangeId == "CZCE"){
        return 1
    } else if(productId == "SHBond") {
        return 10
    } else {
        let index = T_instrumentList.findIndex(function(value, index, arr){
                return value['productId'] == productId;
            })
        return T_instrumentList[index]['volumeMultiple']
    }
    
}

function ReProductId(sysCode) {
    let index = T_modelList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return 'Kzz'
    }
    return T_modelList[index]['productId']
}

function ReInstrumentName(sysCode){
    let index = T_modelList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return sysCode
    }
    return T_modelList[index]['instrumentName']
}

function ReFutureMainId(sysCode) {
    let index = T_futureMain.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    return T_futureMain[index]['instrumentId']
}

function ReFutureMainName(sysCode) {
    let index = T_futureMain.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    return T_futureMain[index]['instrumentName']
}

function ReMainInsCode(sysCode) {
    let index = T_MainAndINS.findIndex(function(value, index, arr){
        return value.main == sysCode;
    })
    if(index == -1){
        return 0
    }
    return T_MainAndINS[index]['INS']
}

function ReZhplateCHName(sysCode) {

    let index = T_ZhPlateList.findIndex(function(value, index, arr){
        return value.IndexID == sysCode;
    })
    if(index == -1){
        return sysCode
    }
    return T_ZhPlateList[index]['ChineseDfinition']
}

function ReZhplatePerClose(sysCode) {
    let index = T_ZhPlateList.findIndex(function(value, index, arr){
        return value.IndexID == sysCode;
    })
    if(index == -1){
        return 0
    }
    return T_ZhPlateList[index]['PreClosePoint']
}

function ReFutureMainCode(id) {
    let index = T_futureMain.findIndex(function(value, index, arr){
        return value['instrumentId'] == id;
    })
    return T_futureMain[index]['sysCode']
}

function RePriceDecimal(productId) {
    let index = T_instrumentList.findIndex(function(value, index, arr){
        return value['productId'] == productId;
    })
    return T_instrumentList[index]['priceDecimal']
}

function ReProductType(productId) {
    let index = T_instrumentList.findIndex(function(value, index, arr){
        return value['productId'] == productId;
    })
    return T_instrumentList[index]['productType']
}
function ReMarketPrePrice(sysCode) {
    let index = T_ysetCloseList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return '0'
    }
    return T_ysetCloseList[index]['yestClose']
}

function ReIsRong(sysCode) {
    let index = T_ysetCloseList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return 'N'
    }
    return T_ysetCloseList[index]['isRong']
}

function ReExchangeId(sysCode) {
    let index = T_modelList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    return T_modelList[index]['exchangeId']
}

function ReTradingDay(exchangeId) {
    let index = T_tradingdayList.findIndex(function(value, index, arr){
        return value['exchangeId'] == exchangeId;
    })
    return T_tradingdayList[index]['tradingday']
}

function ReExpireDate(sysCode) {
    let index = T_futureEtfOptionList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return '—'
    }
    let SSdate = getDiffDate(T_futureEtfOptionList[index]['expireDate'])
    return SSdate+'日'
}


function ReStrikePrice(sysCode) {
    let index = T_futureEtfOptionList.findIndex(function(value, index, arr){
        return value['sysCode'] == sysCode;
    })
    if(index == -1){
        return '—'
    }
    return T_futureEtfOptionList[index]['strikePrice']
}

function ResetListByTagName(arr, tagname){
    let nobj = {}

    arr.forEach(function (item) {
        if (nobj[item[tagname]]) {
            nobj[item[tagname]] = [item, ...nobj[item.Rank]]
        } else {
            nobj[item[tagname]] = [item]
        }
    });
    return nobj
}

function getToday() {
    var now = new Date();
    var year = now.getFullYear();       //年
    var month = now.getMonth() + 1;     //月
    var day = now.getDate();  
    let Amonth = month < 10 ? '0'+month : month
    let Aday = day < 10 ? '0'+day : day
    let today = year.toString()+Amonth.toString()+Aday.toString()
    return today

}

function RePortPage(sysCode) {
    let productId = ReProductId(sysCode)
    let productType = ReProductType(productId)
    let page
    switch (productType){
        case "1a":  //股票
        case '41':  //港股
        case "1b":  //基金
        case "1d":  //债券
        case "1e":  //国债逆回购
        case "1p":  //港股通
            page = "k1";
            break;
        case "1c":  //指数
            page = "k3";
            break;
        case "21":  //期货
            page = "k2";
            break;
        case "31": //延期交收
        case "32": //现货实盘
        case "33": //现货实盘国际版
        case "34": //现货即期
        case "39": //上海金
            page = "k4";
            break;
        case "22":  //期货期权
        case "1l":  //ETF期权
        case "26":  //中金所期权
            page = "k5";
            break;
        
        case "1g":  //板块指数
        default:
            page = 'none';
    }
    return page
}

function ReBidAskMaxRow(sysCode) {
    let EID = ReExchangeId(sysCode)
    let productId = ReProductId(sysCode)
    let productType = ReProductType(productId) 
    let ret = 0
    switch (productType){
        case "1a":  //股票
        case "1b":  //基金
        case "1d":  //债券
        case "1e":  //国债逆回购
            ret = 5;
            break;
        case "1c":  //指数
        case "1g":  //板块指数
            ret = 0;
            break;
        case "21":  //期货
        case "22":  //期货期权
            if (EID == 'SHFE'){
                ret = 5;
            }else{
                ret = 1;
            }
            break;
        case "1l":  //ETF期权
        default:
            ret = 5;
            break;
    }
    return ret;
}



function chack_gMshow(){
    if(g_MshowType == 'port') {
        if (g_Mshow1 == 2) {
            document.getElementById('right').style.display = 'block'
            document.getElementById('market').style.display = 'block'
        } else if (g_Mshow1 == 1) {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'block'
    
        } else {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'none'
        }
    } else if(g_MshowType == 'single') {
        if (g_Mshow2 == 2) {
            document.getElementById('right').style.display = 'block'
            document.getElementById('market').style.display = 'block'
        } else if (g_Mshow2 == 1) {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'block'
    
        } else {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'none'
        }
    } else if(g_MshowType == 'noRight') {
        if(g_Mshow3 == 0) {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'block'
        } else if(g_Mshow3 == 1) {
            document.getElementById('right').style.display = 'none'
            document.getElementById('market').style.display = 'none'
        }
        
    }
    
}

function SetDivDisplay(id, show) {
    if (show == true)
        document.getElementById(id).style.display = "none";
    else
        document.getElementById(id).style.display = "";
}

const UserDefault_OptionalName = 'UserDefault_OptionalList'

function setStorage(content){
  if (typeof content !== 'string') {
    content = JSON.stringify(content)
  }
  window.localStorage.setItem(UserDefault_OptionalName, content)
}

/**
 * 获取localStorage
 */
function getStorage() {
  return JSON.parse(window.localStorage.getItem(UserDefault_OptionalName))
}

/**
 * 删除localStorage
 */
function removeStorage(){
  window.localStorage.removeItem(UserDefault_OptionalName)
}



//置顶localStorage
const stick_name = 'stickName'

function setStickStorage(content) {
    if (typeof content !== 'string') {
        content = JSON.stringify(content)
      }
      window.localStorage.setItem(stick_name, content)
}

function getStickStorage() {
    return JSON.parse(window.localStorage.getItem(stick_name))
}

//获取各时段平均值
function getMean(arr){
    // alert(arr)
    let yarr = arr || []
    let newarr=[]
    for(i=1;i<=yarr.length;i++){
        var b = yarr.slice(0,i).reduce(function(a,b){
            return Number(a) + Number(b)
        })
        var a = b / i
        newarr.push(a.toFixed(g_priceDecimal+1))
    }
    return newarr
}





function ReShortNum(num){
    var snum = num.toString()
    var len = snum.split('.')[0].length
    let index = len == '3'|| len == '4' ? 0 : 3-len
    return index

}
function NumTransform(num, index) {
    var index = arguments[1] ? arguments[1] : 0;
    num = parseInt(num);
    if (num < 10000)
        return num;
    else if (num < 100000000)
        return (num / 10000).toFixed(index) + '万';
    else if (num < 1000000000000)
        return (num / 100000000).toFixed(index) + '亿';
    else
        return (num / 1000000000000).toFixed(index) + '万亿';
}

function NumTransform4(num) {

    num = parseInt(num);
    if(num< 10000) {
        return num
    } else if (num < 100000000){
        let index = ReShortNum(num / 10000)
        return (num / 10000).toFixed(index) + '万';
    }else if (num < 1000000000000){
        let index = ReShortNum(num / 100000000)
        return (num / 100000000).toFixed(index) + '亿';
    }
    
}
function NumTransform1(num) {

    num = parseInt(num);
    if(num < 0) {
        if (num > -10000){
            return num;
        }else if (num > -100000000){       
            return (num / 10000).toFixed(2) + '万';
        }else if (num > -1000000000000){
            return (num / 100000000).toFixed(2) + '亿';
        }else{
            return (num / 1000000000000).toFixed(2) + '万亿';
        } 
    } else {
        if (num < 10000){
            return num;
        }else if (num < 100000000){
            let index = ReShortNum(num / 10000)
            return (num / 10000).toFixed(index) + '万';
        }else if (num < 1000000000000){
            let index = ReShortNum(num / 100000000)
            return (num / 100000000).toFixed(index) + '亿';
        }else{
            let index = ReShortNum(num / 1000000000000)
            return (num / 1000000000000).toFixed(index) + '万亿';
        } 
    }
    

}

function NumTransform2(num, index) {
    var index = arguments[1] ? arguments[1] : 0;
    num = parseInt(num);
    if (num < 10000)
        return num;
    else if (num < 100000000)
        return (num / 10000).toFixed(index) + '万';
    else if (num < 1000000000000)
        return (num / 100000000).toFixed(index) + '亿';
    else
        return (num / 1000000000000).toFixed(index) + '万亿';
}
//num-原始数量 如果是股票的话 ÷100
function ProduceVolume(num, index) {
    
    var index = arguments[1] ? arguments[1] : 0;
    num = isNaN(num) ? 0 : parseInt(num);
    let str;
    switch (g_productId) {
        case "KSH": //科创板
        case "SHA": //上海A股；；
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
        case "BJA":  //北京A股
		
            str = NumTransform((num + 99) / 100, index);
            //if(type == 0) 
            str += "手";
            break;
        case "SZBond":
        case "SZBondRep":
            str = NumTransform(num / 10, index);
            str += "手";
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = NumTransform(num, index);
    }
    return str;
}

function ProduceVolume4(num, productId, index) {
    
    var index = arguments[1] ? arguments[1] : 0;
    num = isNaN(num) ? 0 : parseInt(num);
    let str;
    switch (productId) {
        case "KSH": //科创板
        case "SHA": //上海A股
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
        case "BJA":  //北京A股
            str = NumTransform((num + 99) / 100, index);
            //if(type == 0)
            break;
        case "SZBond":
        case "SZBondRep":
            str = NumTransform(num / 10, index);
            str += "手";
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = NumTransform(num, index);
    }
    return str;
}

function ProduceVolume5(num,productId) {
    //var type = arguments[2] ? arguments[2] : 0;
    num = isNaN(num) ? 0 : parseInt(num);
    let str;
    switch (productId) {
        case "KSH": //科创板
        case "SHA": //上海A股
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
		case "BJA":  //北京A股
            str = NumTransform1((num + 99) / 100);
            //if(type == 0)
            break;
        case "SZBond":
        case "SZBondRep":
            str = NumTransform1(num / 10);
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = NumTransform1(num);
    }
    return str;
}

function ProduceVolume6(num) {
    //var type = arguments[2] ? arguments[2] : 0;
    num = isNaN(num) ? 0 : parseInt(num);
    let str = NumTransform1(num);
    return str;
}
function ProduceVolume7(num,index) {
    num = isNaN(num) ? 0 : parseInt(num);
    let str = NumTransform(num,index);
    return str;
}
//没有手
function ProduceVolume2(num, index) {
    //var type = arguments[2] ? arguments[2] : 0;
    num = isNaN(num) ? 0 : parseInt(num);
    let str;
    switch (g_productId) {
        case "KSH": //科创板
        case "SHA": //上海A股
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
		case "BJA":  //北京A股
            str = NumTransform2((num + 99) / 100, index);
            //if(type == 0)
            //str += "手";
            break;
        case "SZBond":
        case "SZBondRep":
            str = NumTransform2(num / 10, index);
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = NumTransform2(num, index);
    }
    return str;
}

//不加汉字 如"万亿手" 
function ProduceVolume3(num) {
    num = isNaN(num) ? 0 : parseInt(num);
    let str;
    switch (g_productId) {
        case "KSH": //科创板
        case "SHA": //上海A股
        case "CHINEXT": //创业板
        case "SME": //中小板
        case "SZA": //深圳A股
        case "SZIndex": //深圳指数
        case "SHETF":   //基金
        case "SZETF":   //基金
        case "BJA":  //北京A股
            str = parseInt((Number(num) + 99) / 100);
            break;
        case "SZBond":
        case "SZBondRep":
            str = parseInt(Number(num)  / 10);
            break;
        case "SHIndex": //上海指数
		case "SHBondRep":
        case "SHBond":
        default:
            str = num;
    }
    return str;
}

function PriceTransform(num) {
    num = parseFloat(num);
    if (IsZero(num))
        return "-";
    else if (IsNumberMax(num))
        return "&#8212;";
    else
        return num.toFixed(g_priceDecimal);
}

function PriceTransform1(num) {
    num = parseFloat(num);
    if (IsZero(num))
        return "-";
    else if (IsNumberMax(num))
        return "&#8212;";
    else if(num<= 0.01 || IsOverTen(num))
        return '—'
    else
        return num.toFixed(g_priceDecimal);
}

function IsOverTen(num) {
    num = parseFloat(num);
    if (Math.abs(num - 999999999.9999) < g_doubleMin)
        return true;
    else
        return false;
}
/**
 * 计算价格涨跌幅百分比
 * @param {Object} price 当前价
 * @param {Object} yclose 昨收价
 */
function ratioCalculate(price, yclose) {
    return ((price - yclose) / yclose * 100).toFixed(2);
}

function ratioCalculate2(price, yclose) {
    return (Math.abs(price - yclose) / yclose * 100).toFixed(2);
}

function ratioCalculate3(price, yclose) {
    return (Math.abs(price - yclose) / yclose * 100).toFixed(1);
}


/**
 * 15:20 时:分 格式时间增加num分钟
 * @param {Object} time 起始时间
 * @param {Object} num
 */
function addTimeStr(time, num) {
    var hour = time.split(':')[0];
    var mins = Number(time.split(':')[1]);
    var mins_un = parseInt((mins + num) / 60);
    var hour_un = parseInt((Number(hour) + mins_un) / 24);
    if (mins_un > 0) {
        if (hour_un > 0) {
            var tmpVal = ((Number(hour) + mins_un) % 24) + "";
            hour = tmpVal.length > 1 ? tmpVal : '0' + tmpVal;//判断是否是一位
        } else {
            var tmpVal = Number(hour) + mins_un + "";
            hour = tmpVal.length > 1 ? tmpVal : '0' + tmpVal;
        }
        var tmpMinsVal = ((mins + num) % 60) + "";
        mins = tmpMinsVal.length > 1 ? tmpMinsVal : 0 + tmpMinsVal;//分钟数为 取余60的数
    } else {
        var tmpMinsVal = mins + num + "";
        mins = tmpMinsVal.length > 1 ? tmpMinsVal : '0' + tmpMinsVal;//不大于整除60
    }
    return hour + ":" + mins;
}

//时间 09:30:01
function CurentTime() {
    var now = new Date();

    //var year = now.getFullYear();       //年
    //var month = now.getMonth() + 1;     //月
    //var day = now.getDate();            //日

    var hh = now.getHours();            //时
    var mm = now.getMinutes();          //分
    var ss = now.getSeconds();           //秒

    //var clock = year + "-";
    var clock = "";
    //if (month < 10)
    //    clock += "0";

    //clock += month + "-";

    //if (day < 10)
    //    clock += "0";

    //clock += day + " ";

    if (hh < 10)
        hh = "0" + hh;

    clock += hh + ":";
    if (mm < 10)
        mm = "0" + mm;
    clock += mm + ":";

    if (ss < 10)
        ss = "0" + ss;
    clock += ss;
    return (clock);
}

//获取增加指定分钟数的数组  如 09:30增加2分钟  结果为 ['09:31','09:32'] 
//9:30-11:30 其中11:30不需要产生
function getNextTime(startTime, endTime, offset, resultArr) {
    var result = addTimeStr(startTime, offset);
    if (result == endTime){
        return resultArr;
    } else {
        resultArr.push(result);
        return getNextTime(result, endTime, offset, resultArr);
    }
}
function timeToNum(b_time){
    let ntime = b_time.substring(0, 2)+b_time.substring(3, 5)
    return Number(ntime)
}

// function timeToNum1(b_time){
//     let ntime = b_time.substring(0, 2)+b_time.substring(3, 5)
//     return Number(ntime)
// }

function keepLong(stime){
    let timeNum = Number(stime.substring(0, 2))*60+Number(stime.substring(3, 5))-30
    let hour = String(parseInt(timeNum/60))
    let min = timeNum % 60 < 10? '0'+String(timeNum % 60) : String(timeNum % 60)
    let ntime = Number(hour+min)
    return ntime
}
////跨夜 21:00-02:30
//function getNextTime2(startTime, endTime, offset, resultArr) {
//    var result = addTimeStr(startTime, offset);
//    //if ((result == endTime) || (result > endTime)) {
//    if (result == endTime) { 
//        return resultArr;
//    } else {
//        resultArr.push(result);
//        return getNextTime2(result, endTime, offset, resultArr);
//    }
//}

//9:30-11:30 其中11:30不需要产生
function time_arr(timestr) {
    let timestrArray = timestr.split('$');
    var timeArr = new Array();

    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
        timeArr.push(timestrArray[i]);
        timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 1, timeArr));
    }
    timeArr.push(timestrArray[timestrArray.length - 1]);
    return timeArr;
}

function generate_x_label(timestr) {
    let timestrArray = timestr.split('$');
    let timeArr = new Array();
    let timeArr2 = new Array();
    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
        timeArr.length = 0;
        timeArr.push(timestrArray[i]);
        timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 1, timeArr));
        for (let k = 0; k < timeArr.length; k++) {
            if (k % 30 == 0)
                timeArr2.push(timeArr[k]);
        }
    }
    timeArr2.shift();

    let x_labels = new Array();
    for (j = 0; j < timeArr2.length; j++) {
        x_labels.push({ xAxis: timeArr2[j] });
    }
    return x_labels;
}

function generate_x_label1(timestr,time_len) {
    let timestrArray = timestr.split('$');
    let timeArr = new Array();
    let timeArr2 = new Array();
    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
        timeArr.length = 0;
        timeArr.push(timestrArray[i]);
        timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 1, timeArr));
        for (let k = 0; k < timeArr.length; k++) {
            if (k % (time_len+1) == 0)
                timeArr2.push(timeArr[k]);
        }
    }
    timeArr2.shift();

    let x_labels = new Array();
    for (j = 0; j < timeArr2.length; j++) {
        x_labels.push({ xAxis: timeArr2[j] });
    }
    return x_labels;
}

function generate_x_label2(timestr) {
    let timestrArray = timestr.split('$');
    let timeArr = new Array();
    let timeArr2 = new Array();
    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
        timeArr.length = 0;
        timeArr.push(timestrArray[i]);
        timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 1, timeArr));
        for (let k = 0; k < timeArr.length; k++) {
            if (k % 60 == 0)
                timeArr2.push(timeArr[k]);
        }
    }
    timeArr2.shift();

    let x_labels = new Array();
    for (j = 0; j < timeArr2.length; j++) {
        x_labels.push({ xAxis: timeArr2[j] });
    }
    return x_labels;
}
//function generate_x_label_array(timestr) {
//    let timestrArray = timestr.split('$');
//    let timeArr = new Array();
//    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
//        timeArr.push(timestrArray[i]);
//        if (timestrArray[i] > timestrArray[i + 1]) //跨夜
//            timeArr.concat(getNextTime2(timestrArray[i], timestrArray[i + 1], 30, timeArr));
//        else
//            timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 30, timeArr));
//    }
//    timeArr.push(timestrArray[timestrArray.length - 1]);
//    return timeArr;
//}

//function generate_x_label(timestr) {
//    let timestrArray = timestr.split('$');
//    let timeArr = new Array();
//    for (i = 0, len = timestrArray.length; i < len; i = i + 2) {
//        timeArr.push(timestrArray[i]);
//        if (timestrArray[i] > timestrArray[i + 1]) //跨夜
//            timeArr.concat(getNextTime2(timestrArray[i], timestrArray[i + 1], 30, timeArr));
//        else
//            timeArr.concat(getNextTime(timestrArray[i], timestrArray[i + 1], 30, timeArr));

//    }
//    timeArr.shift();

//    let x_labels = new Array();
//    for (j = 0; j < timeArr.length; j++) {
//        x_labels.push({ xAxis: timeArr[j] });
//    }
//    return x_labels;
//}

function Hour_changeVol1(ll,open){
    var side = []
    for(var i=0;i<ll.length;i++){
        if(i==0){
            side[0] = parseFloat(ll[0]) - parseFloat(open)
        }else{
            side[i] = parseFloat(ll[i])-parseFloat(ll[i-1])
        }
    }
    return side
}
function Hour_last(ll, open){
    var side = []
    for(var i=0;i<ll.length;i++){
        if(i==0){
            side[0] = open
        }else{
            side[i] = ll[i-1]
        }
    }
    return side
}

function get_upPer(UpDown,yestClose){
    var side = []
    for(var i=0;i<UpDown.length;i++){  
        let UpDownPer = (parseFloat(UpDown[i]) / parseFloat(yestClose[i]))*100
        side.push(UpDownPer)
        
    }
    return side
}

function FloatEqual(f1, f2) {
    f1 = parseFloat(f1);
    f2 = parseFloat(f2);
    if (Math.abs(f1 - f2) < g_doubleMin)
        return true;
    else
        return false;
}

function IsMaxValue(num){
    num = parseFloat(num)
    if(Math.abs(num)>= Number.MAX_VALUE){
        return true
    }else{
        return false
    }
}

function IsZero(num) {
    return FloatEqual(num, 0);
}

function IsNumBig(num) {
    if(Number(num) > 100000) {
        return true
    } else {
        return false
    }
}

function IsNumZero(num) {
    if(Number(num) <= 0.01) {
        return true
    } else {
        return false
    }
}

function IsNumberMax(num) {
    num = parseFloat(num);
    if (Math.abs(num - Number.MAX_VALUE) < g_doubleMin)
        return true;
    else
        return false;
}

function NumToChinese(num) {
    num = Number(num);
    switch (num) {
        case 1:
            return "一";
        case 2:
            return "二";
        case 3:
            return "三";
        case 4:
            return "四";
        case 5:
            return "五";
        case 6:
            return "六";
        case 7:
            return "七";
        case 8:
            return "八";
        case 9:
            return "九";
        case 10:
            return "十";
        default:
            return "";
    }
}

function GetStockStatus(MDSecurityStat) {
    switch (MDSecurityStat) {
        case "0":
            return "开盘前";
        case "1":
            return "集合竞价";
        case "2":
            return "连续交易";
        case "3":
            return "休市";
        case "4":
            return "停牌";
        case "5":
            return "长期停牌";
        case "6":
            return "波动性中断";
        case "7":
            return "熔断可恢复";
        case "8":
            return "熔断不可恢复";
        case "9":
            return "闭市";
        case "a":
            return "其它";
        case "b":
            return "收盘集合竞价";
        case "c":
            return "集中撮合(盘后定价)";
        case "d":
            return "连续交易(盘后定价)";
        case "e":
            return "闭市(盘后定价)";
        case "f":
            return "开盘前(盘后定价)";
        default:
            return "未知";
    }
}

function IsNotNUm(strname) {
    if(strname == '—' || isNaN(strname)){
        return true
    } else {
        return false
    } 
}

//控制操作tab的高亮显示 参数(one,索引号：1开始)
function setTab(name, cursel, links_len) {
    for (var i = 1; i <= links_len; i++) {
        var menu = document.getElementById(name + i);
        var menudiv = document.getElementById(name + i +"_content" );
        if (i == cursel) {
            menu.className = "on";
            menudiv.style.display = "block";
        }
        else {
            menu.className = "off";
            menudiv.style.display = "none";
        }
    }
}

//c#的bool转换为JS的0-1
function ParseBoolean(b_CS) {
    if ((b_CS == "true") || (b_CS == "True") || (b_CS == "TRUE") )
        return true;
    else if (b_CS == true)
        return true;
    else
        return false;
}



function move_div(){
    var oDiv = document.getElementById('showDiv')
    var title = document.getElementById('top_title')
    var disX = 0;
    var disY = 0;
    var isDown = false;
    title.onmousedown = function (ev) {
        title.style.cursor = 'move'
        var oEvent = ev || event;
        
        disX = oEvent.clientX - oDiv.offsetLeft;
        disY = oEvent.clientY - oDiv.offsetTop;
        isDown = true
        
        document.onmousemove = function (ev) {
            if(isDown == false){
                return
            }
            var oEvent = ev || event;
            var l = oEvent.clientX - disX;
            var t = oEvent.clientY - disY;
            //此处的判断是为了防止拖拽框被拖出屏幕可视区域
            if (l < 0) {
                l = 0;
            } else if (l > document.documentElement.clientWidth - oDiv.offsetWidth) {
                l = document.documentElement.clientWidth - oDiv.offsetWidth;
            }
            if (t < 0) {
                t = 0;
            } else if (t > document.documentElement.clientHeight - oDiv.offsetHeight) {
                t = document.documentElement.clientHeight - oDiv.offsetHeight;
            }
            oDiv.style.left = l + 'px';
            oDiv.style.top = t + 'px';
        };
        //此处是为了防止在火狐浏览器下拖拽时会出现的两次阴影的效果，此处代码可以禁用
        document.onmouseup = function () {
            isDown = false
            title.style.cursor = 'default'
            document.onmousemove = null;
            document.onmouseup = null;
        }
    }
    
}

function IsStockCode(productid){
    let productList = ["KSH", "SHA", "SHETF", "CHINEXT", "SME", "SZA", "SZETF"]
    let index = productList.findIndex(productid)
    return index == -1 ? false : true
 }

 var _setInterval = setInterval
 window.setInterval = function(callback,time,params) {
   var params = Array.prototype.slice.call(arguments,2);
   var _callback = function() {
     callback.apply(null,params);
   }
   var intervalId =  _setInterval(_callback,time)
   return intervalId
 }

 function getDiffDate(targe) {
    let side = targe.substring(0,4)+'/'+targe.substring(4,6)+'/'+targe.substring(6,8)
    let date1 = new Date(side);
    let date2 = new Date();
    date1 = new Date(date1.getFullYear(), date1.getMonth(), date1.getDate());
    date2 = new Date(date2.getFullYear(), date2.getMonth(), date2.getDate());
    const diff = date1.getTime() - date2.getTime();
    const diffDate = diff / (24 * 60 * 60 * 1000);
    return diffDate;
}


const singalShowOrderTradeName = 'singal_ShowOrderTrade_Name'
const singalShowPositionName = 'singal_ShowPosition_Name'
const singalOptionTradeName = 'singal_OptionTrade_Name'
const singalOptionPositionName = 'singal_OptionPosition_Name'
const singalCtpTradeName = 'singal_CtpTrade_Name'
const singalCtpPositionName = 'singal_CtpPosition_Name'

function setSingalOrderTradeStorage(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalShowOrderTradeName, content)
  }
  

function getSingalOrderTradeStorage() {
    return JSON.parse(window.localStorage.getItem(singalShowOrderTradeName))
  }
  

  function removeSingalOrderTradeStorage(){
    window.localStorage.removeItem(singalShowOrderTradeName)
}

function setSingalPositionStorage(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalShowPositionName, content)
  }
  
 
function getSingalPositionStorage() {
    return JSON.parse(window.localStorage.getItem(singalShowPositionName))
}
  
function removeSingalPositionStorage(){
    window.localStorage.removeItem(singalShowPositionName)
}

//  期权买卖点
function setSingalOptionTrade(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalOptionTradeName, content)
}
  
 
function getSingalOptionTrade() {
    return JSON.parse(window.localStorage.getItem(singalOptionTradeName))
}
  
function removeSingalOptionTrade(){
    window.localStorage.removeItem(singalOptionTradeName)
}

//期权持仓线

function setSingalOptionPosition(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalOptionPositionName, content)
}
  
 
function getSingalOptionPosition() {
    return JSON.parse(window.localStorage.getItem(singalOptionPositionName))
}
  
function removeSingalOptionPosition(){
    window.localStorage.removeItem(singalOptionPositionName)
}

//期货买卖点
function setSingalCtpTrade(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalCtpTradeName, content)
}
  
 
function getSingalCtpTrade() {
    return JSON.parse(window.localStorage.getItem(singalCtpTradeName))
}
  
function removeSingalCtpTrade(){
    window.localStorage.removeItem(singalCtpTradeName)
}

//期货持仓线
function setSingalCtpPosition(content){
    if (typeof content !== 'string') {
      content = JSON.stringify(content)
    }
    window.localStorage.setItem(singalCtpPositionName, content)
}
  
 
function getSingalCtpPosition() {
    return JSON.parse(window.localStorage.getItem(singalCtpPositionName))
}
  
function removeSingalCtpPosition(){
    window.localStorage.removeItem(singalCtpPositionName)
}

//手机号登录后保存自选股顺序
// const loginSyscodeListTmp = "login_syscode_list_tmp"


// function setLoginSyscodeListTmp(content){
//     if (typeof content !== 'string') {
//       content = JSON.stringify(content)
//     }
//     window.localStorage.setItem(loginSyscodeListTmp, content)
// }
  
 
// function getLoginSyscodeListTmp() {
//     return JSON.parse(window.localStorage.getItem(loginSyscodeListTmp))
// }


//防抖函数
const debounce = (req,times=1000) => {
    let timer = null;
    return () => { 
        timer && clearTimeout(timer)        
        timer = setTimeout(() => {
            req();
        }, times)
    }
}

//节流函数
// const throttle = (req, times=2000) => { 
//     let timer = null;
//     let startTime = Date.now();
//     return () => {
//         let curTime = Date.now();
//         let remaining = times - (curTime - startTime);
//         clearTimeout(timer)
//         if(remaining <= 0) {
//             req()
//             startTime = Date.now()
//         } else {
//             timer = setTimeout(req, remaining)
//         }
//     }
// }

function throttle(func, delay) {
    var delay = delay || 1000;
    let lastTime = 0
    return function(args) {
        var context = this;
        const nowTime = new Date().getTime()
        const remainTime = delay - (nowTime - lastTime)
        if (remainTime <= 0) {
            func.call(context, args);
            lastTime = nowTime
        }
    }
}

function codeAndExidToSyscode(code,exid){
    let strList = ['','.SH','.SZ','.SK','.BJ']
    let exidNum = Number(exid)
    let idStr = strList[exidNum]
    let sysCode = code+idStr
    return sysCode
} 

const ObsplitTime = function(value) {
    let newtime = value.substring(4)
    let date = newtime.substring(0,2)+'-'+newtime.substring(2)
    // console.log(newtime)
    return date
}
function threeMonth() {
	let dates = new Date()
	let loadYears = dates.getFullYear()
	let loadMonth = dates.getMonth() +1
	let beforeMonth
	let beforeYears
	if(loadMonth > 2) {
		beforeMonth = loadMonth - 2
		beforeYears = loadYears
	} else {
		beforeMonth = loadMonth + 12 - 2 
		beforeYears = loadYears - 1
	}
	let loadDay = dates.getDate()
	if (loadMonth >= 1 && loadMonth <= 9) {
    loadMonth = '0' + loadMonth
  }
	if (beforeMonth >= 1 && beforeMonth <= 9) {
    beforeMonth = '0' + beforeMonth
  }
  if (loadDay >= 0 && loadDay <= 9) {
    loadDay = '0' + loadDay
  }
	let startT = beforeYears.toString()+beforeMonth.toString()+'01'
	let endT = loadYears.toString()+loadMonth.toString()+loadDay.toString()
	return [startT,endT]
}