function getAllUrlParams(url) {
  // 用JS拿到URL，如果函数接收了URL，那就用函数的参数。如果没传参，就使用当前页面的URL
  var queryString = url ? url.split('?')[1] : window.location.search.slice(1);
  // 用来存储我们所有的参数
  var obj = {};
  // 如果没有传参，返回一个空对象
  if (!queryString) {
      return obj;
  }
  // stuff after # is not part of query string, so get rid of it
  queryString = queryString.split('#')[0];
  // 将参数分成数组
  var arr = queryString.split('&');
  for (var i = 0; i < arr.length; i++) {
      // 分离成key:value的形式
      var a = arr[i].split('=');
      // 将undefined标记为true
      var paramName = a[0];
      var paramValue = typeof (a[1]) === 'undefined' ? true : a[1];
      // 如果调用对象时要求大小写区分，可删除这两行代码
      //paramName = paramName.toLowerCase();
      //if (typeof paramValue === 'string') paramValue = paramValue.toLowerCase();
      // 如果paramName以方括号结束, e.g. colors[] or colors[2]
      if (paramName.match(/\[(\d+)?\]$/)) {
          // 如果paramName不存在，则创建key
          var key = paramName.replace(/\[(\d+)?\]/, '');
          if (!obj[key]) obj[key] = [];
          // 如果是索引数组 e.g. colors[2]
          if (paramName.match(/\[\d+\]$/)) {
              // 获取索引值并在对应的位置添加值
              var index = /\[(\d+)\]/.exec(paramName)[1];
              obj[key][index] = paramValue;
          } else {
              // 如果是其它的类型，也放到数组中
              obj[key].push(paramValue);
          }
      } else {
          // 处理字符串类型
          if (!obj[paramName]) {
              // 如果如果paramName不存在，则创建对象的属性
              obj[paramName] = paramValue;
          } else if (obj[paramName] && typeof obj[paramName] === 'string') {
              // 如果属性存在，并且是个字符串，那么就转换为数组
              obj[paramName] = [obj[paramName]];
              obj[paramName].push(paramValue);
          } else {
              // 如果是其它的类型，还是往数组里丢
              obj[paramName].push(paramValue);
          }
      }
  }
  return obj;
}

let isFocus = false;
let lastPage_Module = ''
let g_bgColor = "#000000";  //背景 "#1f212d"
let g_upColor = "#FF5C5C";//"#F9293E";//涨颜色
let g_downColor = "#39E365";//"#00FF00";//跌颜色 "#00aa3b";
let g_allColor = '#E6A23C'
let g_marketZeroColor = "#DDDDDD";
let g_doubleMin = 0.000001;
let g_doubleMinNegative = -0.000001;
let g_ma5Color = "#FFFFFF";
let g_ma10Color = "#6AA6EE";
let g_ma20Color = "#ffab42";
let g_ma30Color = "#00940b";
let g_ma180Color = '#FF00FF'
let g_marketUpArrow = '<svg class="icon" aria-hidden="true"><use xlink:href="#icon-up"></use></svg>';
let g_marketDownArrow = '<svg class="icon" aria-hidden="true"><use xlink:href="#icon-down"></use></svg>';
let g_marketMaxRow = 300;
let g_marketSize = 0;
let g_marketLihe = 0;
let g_haveDom = false
let g_AbnormalLihe = 0
let g_AbnormalSize = 0
let g_haveAbnormalDom = false
let bodyWidth = document.documentElement.clientWidth - 54;


let Index_InstrumentID = getAllUrlParams().sIndex_InstrumentIDArray
let Index_InstrumentIDArray = Index_InstrumentID.split(',')
// let index_insturmentNameArray = getAllUrlParams().sIndex_InsturmentNameArray.split(',')
let Option_InstrumentID = getAllUrlParams().sOption_InstrumentIDArray
let Option_InstrumentIDArray = Option_InstrumentID.split(',') 
let ServerPath = decodeURIComponent(getAllUrlParams().sServerPath)
let sURL3 = getAllUrlParams().sURL3//涨跌榜
let sURL4 = getAllUrlParams().sURL4 //获取7x24新闻资讯
let sURL5 = getAllUrlParams().sURL5 //获取哈勃观察列表 
let sURL6 = getAllUrlParams().sURL6 //获取哈勃观察详情
let httpUrl6 = decodeURIComponent(sURL6)
let sURL7 = decodeURIComponent(getAllUrlParams().sURL7) //涨跌总览
let sURL20 = decodeURIComponent(getAllUrlParams().sURL20) //查询涨跌
let indexHtmlURL = decodeURIComponent(sURL3)

let sHttpURL1 = decodeURIComponent(getAllUrlParams().sURL1)

let sHttpURL2 = getAllUrlParams().sURL2
let sHttpU = decodeURIComponent(sHttpURL2)
let sURL8 = getAllUrlParams().sURL8 //查询5天的数据
let sURL9 = getAllUrlParams().sURL9 //查询当天的数据
let sURL10 = getAllUrlParams().sURL10 // //查询板块数据
let sURL11 = getAllUrlParams().sURL11  //查询诊股数据
let sURL12 = getAllUrlParams().sURL12 //查询财务数据
let sHttpURL3 = decodeURIComponent(sURL12)
let sURL13 = getAllUrlParams().sURL13 //查询十大股东
let sURL14 = getAllUrlParams().sURL14 //查询十大流通股东 q
let sURL15 = getAllUrlParams().sURL15 // 查询持仓趋势的数据
let sURL16 = getAllUrlParams().sURL16 //查询仓单的数据
let sURL17 = getAllUrlParams().sURL17 //F10数据
let sURL18 = getAllUrlParams().sURL18 //涨跌总览
let sURL19 = getAllUrlParams().sURL19 //查询资料数据
let sURL21 = getAllUrlParams().sURL21 //自选网址
let sURL22 = decodeURIComponent(getAllUrlParams().sURL22) //板块列表
let sURL23 = getAllUrlParams().sURL23 //领涨/领跌板块列表
let sURL24 = decodeURIComponent(getAllUrlParams().sURL24) //板块实时行情
let sURL25 = getAllUrlParams().sURL25 //黄金行情F10
let k1HtmlURL = decodeURIComponent(sURL19)
let k2HtmlURL = decodeURIComponent(sURL15)
let k3HtmlURL = decodeURIComponent(sURL18)
let portFoUrl = decodeURIComponent(sURL21)
let sURL27 = decodeURIComponent(getAllUrlParams().sURL27) //行情列表排序
let sURL29 = getAllUrlParams().sURL29 //金融日历列表
let sURL30 = decodeURIComponent(getAllUrlParams().sURL30) //金融日历详情
let sURL31 = getAllUrlParams().sURL31 //华鑫视点
let sURL32 = getAllUrlParams().sURL32 //北向资金和认估认购比
let sHttpURL32 = decodeURIComponent(getAllUrlParams().sURL32)
let sURL33 = getAllUrlParams().sURL33
let sHttpUPL33 = decodeURIComponent(sURL33)
let sURL36 = decodeURIComponent(getAllUrlParams().sURL36) // 获取上海金数据
let sURL37 = decodeURIComponent(getAllUrlParams().sURL37) // 可转债查询正股代码
let sURL38 = decodeURIComponent(getAllUrlParams().sURL38)  //正股查询可转债代码
let sURL39 = decodeURIComponent(getAllUrlParams().sURL39)  //基础数据下载包地址
console.log(sURL39)

let Userlogin_Id

//url列表PromiseAjax封装
// async function PromiseAjax(urlStr, urlPath, type = 'GET', data = {}, dataType = 'json') {
//     let urlList = urlStr.split('&')
//     const respones = Promise.any(
//         urlList.map(item => {
//             return new Promise((resolve, reject) => {
//                 $.ajax({
//                     url: item + urlPath,
//                     type,
//                     data,
//                     dataType,
//                     timeout: 3000,
//                     contentType: "application/json;charset=utf-8",
//                     success: function (result) {
//                         resolve(result)
//                     },
//                     error: function (result) {
//                         reject(result)
//                     }

//                 })
//             })
//         })
//     )
//     return await respones
// }



function LoadPortfolio(userId) {
    console.log(userId)
    $.ajax({
        url: portFoUrl+'loadportfolio?userid='+userId,
        type: 'get',
        timeout: 5000,
         success: function (data) {
            let resdata = data.data
            let portList = []
            for(var i=0; i<resdata.length;i++){
                let instrumentId = resdata[i]['instrumentId']
                if(T_modelSyscodeList.includes(instrumentId)){
                    let obj = {}
                    obj['sysCode'] = instrumentId
                    obj['InstrumentName'] = ReInstrumentName(instrumentId)
                    portList.unshift(obj)
                }
            }
            sysCodeTemList = portList.filter((item,index) =>portList.findIndex(i => i.sysCode === item.sysCode) === index )
            getSysCodeTemp(sysCodeTemList)
            let LoginsysCodetemstr = sysCodeTemList.map(item => item.sysCode).join(',')
            window_external.Page_Portfolio_Subscribe(LoginsysCodetemstr) 
            let sysCode = sysCodeTemList.length == 0 ? '' : sysCodeTemList[0]['sysCode'] 
            console.log(sysCode)
            if(Page_Module == 'portfolio') {
                rechartSysCode(sysCode,'1')
            }   
        },
        error: function (jqXHR, textStatus, errorThrown) {
        }
    })
}

function AddPortfolio(sysCode) {
    let post_data= [{
        instrumentType: 'mytype',
        versionId: '111',
        userId: Userlogin_Id,
        instrumentId: sysCode,
        sort: 1
    }]
    $.ajax({
        url: portFoUrl+'addportfolio',
        type: 'post',
        dataType: 'json',
        data: JSON.stringify(post_data),
        contentType: "application/json;charset=utf-8",
        timeout: 3000,
        success: function (data) {
            let obj = {}
            obj['sysCode'] = sysCode
            obj['InstrumentName'] = ReInstrumentName(sysCode)
            sysCodeTemList.unshift(obj)
            getSysCodeTemp(sysCodeTemList)
            if(Page_Module == 'portfolio') {
                // document.getElementById("m_title_follow").innerHTML = "已关注";
                let sysCodetemstr = sysCodeTemList.map(item => item.sysCode).join(',')
                console.log(sysCodetemstr)
                window_external.Page_Portfolio_Subscribe(sysCodetemstr)
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            
        }
    })
}
 // 保存全部自选股
function SaveAllPortfolio(sysCodeList) {

    let post_data= []
    sysCodeList.map((item,index) => {
        let obj = {
            instrumentType: 'mytype',
            versionId: '111',
            userId: Userlogin_Id,
            instrumentId: item.sysCode,
            sort: index+1
        }
        post_data.push(obj)
    })
    $.ajax({
        url: portFoUrl+'saveportfolio',
        type: 'post',
        dataType: 'json',
        data: JSON.stringify(post_data),
        contentType: "application/json;charset=utf-8",
        timeout: 3000,
        success: function (data) {
            // let obj = {}
            // obj['sysCode'] = sysCode
            // obj['InstrumentName'] = ReInstrumentName(sysCode)
            // sysCodeTemList.unshift(obj)
            // getSysCodeTemp(sysCodeTemList)
            // if(Page_Module == 'portfolio') {
            //     // document.getElementById("m_title_follow").innerHTML = "已关注";
            //     let sysCodetemstr = sysCodeTemList.map(item => item.sysCode).join(',')
            //     window_external.Page_Portfolio_Subscribe(sysCodetemstr)
            // }
            // let resdata = data.data 
            // let portList = []
            // for(var i=0; i<resdata.length;i++){
            //     if(T_modelSyscodeList.includes(resdata[i]['instrumentId'])){
            //         let obj = {}
            //         obj['sysCode'] = resdata[i]['instrumentId']
            //         obj['InstrumentName'] = ReInstrumentName(resdata[i]['instrumentId'])
            //         portList.push(obj)
            //     }
            // }
            // sysCodeTemList =  [...portList] 
            // getSysCodeTemp(sysCodeTemList)
            // let LoginsysCodetemstr = sysCodeTemList.map(item => item.sysCode).join(',')
            // window_external.Page_Portfolio_Subscribe(LoginsysCodetemstr) 
            // let sysCode = sysCodeTemList.length == 0 ? '' : sysCodeTemList[0]['sysCode']
            // if(Page_Module == 'portfolio') {
            //     rechartSysCode(sysCode,'1')
            // } 
        },
        error: function (jqXHR, textStatus, errorThrown) {
            
        }
    })
}

function RemovePortfolio(sysCode) {
    let post_data= {
        "userId": Userlogin_Id,
        "instrumentId": sysCode,
    }
    $.ajax({
        url: portFoUrl+'removeportfolio',
        type: 'post',
        data: JSON.stringify(post_data),
        contentType: "application/json;charset=utf-8",
        timeout: 3000,
        success: function (data) {
            let index = sysCodeTemList.findIndex(function(value,index,arr){
                return value.sysCode == sysCode
            })
            sysCodeTemList.splice(index,1)
            getSysCodeTemp(sysCodeTemList)
            if (lastPage_Module == 'portfolio') {
                window_external.Page_Portfolio_UnSubscribe(sysCode)
                let sysCodelen = sysCodeTemList.length
                if(sysCodelen == 0){
                    rechartSysCode('',1)
                } else if(sysCodelen > index){
                    rechartSysCode(sysCodeTemList[index]['sysCode'],1)
                } else {
                    rechartSysCode(sysCodeTemList[0]['sysCode'],1)
                }
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
        }
    })
}

function RemoveAllPortfolio() {
    let post_data= {
        "userId": Userlogin_Id,
    }
    $.ajax({
        url: portFoUrl+'removeallportfolio',
        type: 'post',
        data: JSON.stringify(post_data),
        contentType: "application/json;charset=utf-8",
        timeout: 3000,
        success: function (data) {
            sysCodeTemList = []
            getSysCodeTemp(sysCodeTemList)
        },
        error: function (jqXHR, textStatus, errorThrown) {
        }
    })
}

let Index_TimeFrame = getAllUrlParams().sIndex_Timeframe.split(',')
let Index_Preprice = getAllUrlParams().sIndex_Preprice.split(',')
let Index_PriceDecimal = getAllUrlParams().sIndex_PriceDecimal.split(',')
let Index_ProductId = getAllUrlParams().sIndex_ProductId.split(',')

let User_IsLogin = false


